<?php
// auth_check.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- Session Timeout Settings ---
$timeout_duration = 300; // 5 minutes
$current_path = $_SERVER['REQUEST_URI']; // captures path + query

if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout_duration) {
    session_unset();
    session_destroy();
    header("Location: /smartpay360/auth/session_expired.php?redirect=" . urlencode($current_path));
    exit();
}
$_SESSION['last_activity'] = time();

// --- Authentication Check ---
if (!isset($_SESSION['user_id'])) {
    header("Location: /smartpay360/auth/login.php?redirect=" . urlencode($current_path));
    exit();
}

// --- Optional: Regenerate Session ID every 10 minutes to prevent fixation ---
if (!isset($_SESSION['created'])) {
    $_SESSION['created'] = time();
} elseif (time() - $_SESSION['created'] > 600) {
    session_regenerate_id(true);
    $_SESSION['created'] = time();
}

// --- Optional Role Check Function ---
function require_role($roles = []) {
    global $current_path;
    if (!isset($_SESSION['role'])) {
        header("Location: /smartpay360/auth/login.php?redirect=" . urlencode($current_path));
        exit();
    }
    $userRole = $_SESSION['role'];
    if (is_array($roles) && !in_array($userRole, $roles)) {
        header("Location: /smartpay360/unauthorized.php?redirect=" . urlencode($current_path));
        exit();
    }
}
