<?php
session_start();
require_once '../config/db.php';

$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);

    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();

    if ($user) {
        $_SESSION['reset_user_id'] = $user['id'];
        header("Location: reset_password.php");
        exit;
    } else {
        $message = "User not found. Please check the username.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Forgot Password | SmartPay360</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(to right, #006494, #003554);
      font-family: 'Segoe UI', sans-serif;
    }
    .box {
      max-width: 420px;
      margin: 80px auto;
      padding: 30px;
      background: #fff;
      border-radius: 14px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      color: #003554;
    }
    .btn-primary {
      background-color: #006494;
      border: none;
    }
    .btn-primary:hover {
      background-color: #004f73;
    }
  </style>
</head>
<body>
  <div class="box">
    <h2 class="text-center mb-4">🔑 Forgot Password</h2>
    <p class="text-muted text-center mb-3">Enter your username to reset password</p>

    <?php if ($message): ?>
      <div class="alert alert-warning text-center"><?= $message ?></div>
    <?php endif; ?>

    <form method="post">
      <div class="mb-3">
        <label class="form-label">Username</label>
        <input type="text" name="username" class="form-control" required autofocus>
      </div>
      <button type="submit" class="btn btn-primary w-100">Continue</button>
    </form>

    <div class="text-center mt-3">
      <a href="login.php" class="text-decoration-none">Back to Login</a>
    </div>
  </div>
</body>
</html>
