<?php
session_start();
header('Content-Type: application/json');

// If session expired or user not logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'expired']);
    exit;
}

// Optional: check activity timeout
$timeout_duration = 300; // 5 minutes
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout_duration) {
    session_unset();
    session_destroy();
    echo json_encode(['status' => 'expired']);
    exit;
}

// ✅ Renew session activity timestamp
$_SESSION['last_activity'] = time();

// Respond with status
echo json_encode(['status' => 'active']);
