<?php
session_start();
require_once '../config/db.php';

// Allow access only if unlocked OR admin
if (
    (!isset($_SESSION['authorized_unauth']) || $_SESSION['authorized_unauth'] !== true)
    && (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin')
) {
    header("Location: unauthorized.php");
    exit;
}

$success = "";
$error = "";

// Load roles and branches
$roles = $conn->query("SELECT id, role_name FROM user_roles ORDER BY role_name ASC");
$branches = $conn->query("SELECT id, branch_name FROM branches WHERE status = 'active' ORDER BY branch_name ASC");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $full_name = trim($_POST['full_name']);
    $id_number = trim($_POST['id_number']);
    $phone = trim($_POST['phone']);
    $branch_id = intval($_POST['branch_id']);
    $role_id = intval($_POST['role_id']);

    if ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    } else {
        $stmt = $conn->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
        $stmt->bind_param("ss", $username, $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $error = "Username or email already exists.";
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $status = 'active';

            $stmt = $conn->prepare("INSERT INTO users 
                (username, email, password, full_name, id_number, phone, branch_id, role_id, status, created_at) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
            $stmt->bind_param("sssssssii", $username, $email, $hashed_password, $full_name, $id_number, $phone, $branch_id, $role_id, $status);

            if ($stmt->execute()) {
                $success = "Account created successfully.";
                unset($_SESSION['authorized_unauth']);
            } else {
                $error = "Something went wrong while saving.";
            }
        }
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Register | SmartPay360</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(to right, #006494, #003554);
      font-family: 'Segoe UI', sans-serif;
    }
    .register-box {
      max-width: 540px;
      margin: 60px auto;
      padding: 35px;
      background: #fff;
      border-radius: 14px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    .register-header {
      text-align: center;
      margin-bottom: 25px;
    }
    .register-header h2 {
      font-weight: bold;
      color: #003554;
    }
    .form-control:focus {
      border-color: #006494;
      box-shadow: 0 0 0 0.2rem rgba(0,100,148,.25);
    }
    .btn-primary {
      background-color: #006494;
      border: none;
    }
    .btn-primary:hover {
      background-color: #004f73;
    }
    .logo {
      width: 80px;
      margin-bottom: 12px;
    }
  </style>
</head>
<body>
  <div class="register-box">
    <div class="register-header">
      <img src="../assets/icons/logo.png" alt="SmartPay360 Logo" class="logo">
      <h2>📝 Create Account</h2>
      <p class="text-muted mb-0">Fill in your full details to register</p>
    </div>

    <?php if ($error): ?>
      <div class="alert alert-danger text-center"><?= $error ?></div>
    <?php elseif ($success): ?>
      <div class="alert alert-success text-center"><?= $success ?></div>
      <div class="text-center mt-3">
        <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'Admin'): ?>
          <a href="list_users.php" class="btn btn-primary">View All Users</a>
        <?php else: ?>
          <a href="login.php" class="btn btn-success">Login Now</a>
        <?php endif; ?>
      </div>
    <?php endif; ?>

    <?php if (!$success): ?>
    <form method="post" autocomplete="off">
      <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" name="full_name" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">ID Number</label>
        <input type="text" name="id_number" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Phone Number</label>
        <input type="text" name="phone" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Branch</label>
        <select name="branch_id" class="form-select" required>
          <option value="">-- Select Branch --</option>
          <?php while ($b = $branches->fetch_assoc()): ?>
            <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['branch_name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Role</label>
        <select name="role_id" class="form-select" required>
          <option value="">-- Select Role --</option>
          <?php while ($r = $roles->fetch_assoc()): ?>
            <option value="<?= $r['id'] ?>"><?= htmlspecialchars($r['role_name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Username</label>
        <input type="text" name="username" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Confirm Password</label>
        <input type="password" name="confirm_password" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-primary w-100">Register</button>
    </form>
    <?php endif; ?>

    <div class="text-center mt-3">
      <a href="login.php" class="text-decoration-none">Already have an account? Login</a>
    </div>
  </div>
</body>
</html>
