<?php
session_start();
require_once '../../config/db.php';

// ✅ Logging function
function logPaymentAction($conn, $payment_id, $user_id, $action, $remarks = '') {
    $log = $conn->prepare("INSERT INTO payment_logs (payment_id, user_id, action, remarks) VALUES (?, ?, ?, ?)");
    $log->bind_param("iiss", $payment_id, $user_id, $action, $remarks);
    $log->execute();
}

// Validate input
$payment_id = isset($_POST['payment_id']) ? (int)$_POST['payment_id'] : 0;
if ($payment_id <= 0) {
    $_SESSION['error'] = "Invalid payment ID.";
    header("Location: list.php");
    exit;
}

$supplier_id = (int) $_POST['supplier_id'];
$amount = (float) $_POST['amount'];
$payment_date = $_POST['payment_date'] ?? '';
$reference_no = $_POST['reference_no'] ?? '';
$method = $_POST['method'] ?? '';
$remarks = $_POST['remarks'] ?? '';

if ($supplier_id <= 0 || $amount <= 0 || !$payment_date || !$reference_no || !$method) {
    $_SESSION['error'] = "Please fill all required fields.";
    header("Location: edit.php?id=$payment_id");
    exit;
}

// Ensure reference number is unique (excluding current payment)
$check = $conn->prepare("SELECT id FROM payments WHERE reference_no = ? AND id != ?");
$check->bind_param("si", $reference_no, $payment_id);
$check->execute();
$res = $check->get_result();
if ($res->num_rows > 0) {
    $_SESSION['error'] = "Reference number already exists.";
    header("Location: edit.php?id=$payment_id");
    exit;
}

// Update payment
$stmt = $conn->prepare("
    UPDATE payments 
    SET supplier_id = ?, amount = ?, payment_date = ?, reference_no = ?, method = ?, remarks = ?, updated_at = NOW(), updated_by = ? 
    WHERE id = ?
");
$user_id = $_SESSION['user_id'];
$stmt->bind_param("dssssssi", $supplier_id, $amount, $payment_date, $reference_no, $method, $remarks, $user_id, $payment_id);

if ($stmt->execute()) {
    // ✅ Log update
    logPaymentAction($conn, $payment_id, $user_id, "Updated", "Payment details were modified.");

    $_SESSION['success'] = "✅ Payment updated successfully.";
    header("Location: view.php?id=$payment_id");
    exit;
} else {
    $_SESSION['error'] = "❌ Failed to update payment.";
    header("Location: edit.php?id=$payment_id");
    exit;
}
?>
