<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $loading_id = $_POST['loading_id'] ?? 0;
    $cash = floatval($_POST['cash'] ?? 0);
    $cheque = floatval($_POST['cheque'] ?? 0);
    $cheque_no = trim($_POST['cheque_no'] ?? '');
    $remarks = trim($_POST['remarks'] ?? '');
    $mpesa_array = $_POST['mpesa'] ?? [];
    $created_by = $_SESSION['user_name'] ?? 'system';

    if ($loading_id <= 0) {
        $_SESSION['error'] = "Invalid loading session.";
        header("Location: returns.php");
        exit;
    }

    $mpesa_total = 0;
    foreach ($mpesa_array as $amt) {
        $mpesa_total += floatval($amt);
    }

    $total_amount = $cash + $mpesa_total + $cheque;

    // Prepare insert query
    $query = "INSERT INTO bread_payments 
        (loading_id, cash, mpesa, cheque, cheque_no, remarks, total_amount, created_by) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    
    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("idddssds", $loading_id, $cash, $mpesa_total, $cheque, $cheque_no, $remarks, $total_amount, $created_by);
    
    if ($stmt->execute()) {
        $payment_id = $stmt->insert_id;

        foreach ($mpesa_array as $amt) {
            $amt = floatval($amt);
            if ($amt > 0) {
                $stmt_mpesa = $conn->prepare("INSERT INTO bread_payment_mpesa (payment_id, amount) VALUES (?, ?)");
                if ($stmt_mpesa) {
                    $stmt_mpesa->bind_param("id", $payment_id, $amt);
                    $stmt_mpesa->execute();
                }
            }
        }

        header("Location: print_receipt.php?id=" . $payment_id);
        exit;
    } else {
        $_SESSION['error'] = "Error saving payment: " . $stmt->error;
        header("Location: returns.php");
        exit;
    }
} else {
    header("Location: returns.php");
    exit;
}
