<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Filters
$vehicle_id = isset($_GET['vehicle_id']) ? (int)$_GET['vehicle_id'] : 0;
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

// Conditions
$conditions = [];
$params = [];
$types = '';

if ($vehicle_id > 0) {
    $conditions[] = "v.id = ?";
    $params[] = $vehicle_id;
    $types .= 'i';
}

if (!empty($from_date)) {
    $conditions[] = "bp.payment_date >= ?";
    $params[] = $from_date;
    $types .= 's';
}

if (!empty($to_date)) {
    $conditions[] = "bp.payment_date <= ?";
    $params[] = $to_date;
    $types .= 's';
}

$where = count($conditions) ? 'WHERE ' . implode(' AND ', $conditions) : '';

// Query
$query = "
    SELECT bp.*, l.loading_date, v.vehicle_no, v.driver_name, r.name AS route_name
    FROM bread_payments bp
    JOIN loadings l ON bp.loading_id = l.id
    JOIN vehicles v ON l.vehicle_id = v.id
    JOIN routes r ON l.route_id = r.id
    $where
    ORDER BY bp.payment_date DESC
";

$stmt = $conn->prepare($query);
if (count($params) > 0) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$payments = $stmt->get_result();

// Vehicles for filter
$vehicles = $conn->query("SELECT id, vehicle_no FROM vehicles ORDER BY vehicle_no");
?>

<div class="main-content">
  <h4 class="fw-bold text-primary mb-4"><i class="fas fa-money-bill-wave me-2"></i> Bread Payment History</h4>

  <?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
  <?php elseif (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body">

      <!-- Filters -->
      <form method="GET" class="row g-2 mb-4">
        <div class="col-md-3">
          <select name="vehicle_id" class="form-select form-select-sm">
            <option value="">-- All Vehicles --</option>
            <?php while ($v = $vehicles->fetch_assoc()): ?>
              <option value="<?= $v['id'] ?>" <?= ($vehicle_id == $v['id']) ? 'selected' : '' ?>>
                <?= htmlspecialchars($v['vehicle_no']) ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>

        <div class="col-md-2">
          <input type="date" name="from_date" value="<?= htmlspecialchars($from_date) ?>" class="form-control form-control-sm">
        </div>
        <div class="col-md-2">
          <input type="date" name="to_date" value="<?= htmlspecialchars($to_date) ?>" class="form-control form-control-sm">
        </div>
        <div class="col-md-2">
          <button type="submit" class="btn btn-sm btn-primary w-100">🔎 Filter</button>
        </div>
        <div class="col-md-2">
          <a href="payments_list.php" class="btn btn-sm btn-secondary w-100">🔄 Reset</a>
        </div>
      </form>

      <!-- Table -->
      <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover">
          <thead class="table-dark text-center">
            <tr style="font-size: 13px;">
              <th>#</th>
              <th>Vehicle</th>
              <th>Driver</th>
              <th>Route</th>
              <th>Loading Date</th>
              <th>Payment Date</th>
              <th>Amount</th>
              <th>Method</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody class="text-center" style="font-size: 13px;">
            <?php if ($payments->num_rows > 0): $i = 1; ?>
              <?php while ($row = $payments->fetch_assoc()): ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><?= htmlspecialchars($row['vehicle_no']) ?></td>
                  <td><?= htmlspecialchars($row['driver_name']) ?></td>
                  <td><?= htmlspecialchars($row['route_name']) ?></td>
                  <td><?= date('d-M-Y', strtotime($row['loading_date'])) ?></td>
                  <td><?= date('d-M-Y', strtotime($row['payment_date'])) ?></td>
                  <td class="fw-bold text-end">Ksh <?= number_format($row['cash_amount'] + $row['mpesa_amount'] + $row['cheque_amount'], 2) ?></td>
                  <td><?= ucfirst($row['payment_mode']) ?></td>
                  <td>
                    <a href="print_receipt.php?id=<?= $row['id'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                      🧾 Print
                    </a>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="9" class="text-muted text-center">No bread payments found.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>
