<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Filters
$vehicle_id = $_GET['vehicle_id'] ?? '';
$route_id = $_GET['route_id'] ?? '';
$date_from = $_GET['date_from'] ?? '';
$date_to = $_GET['date_to'] ?? '';

// Get vehicle and route list
$vehicles = $conn->query("SELECT id, vehicle_no FROM vehicles ORDER BY vehicle_no")->fetch_all(MYSQLI_ASSOC);
$routes = $conn->query("SELECT id, name FROM routes ORDER BY name")->fetch_all(MYSQLI_ASSOC);

// Base WHERE clause
$where = "WHERE 1";
$params = [];
$types = "";

if (!empty($vehicle_id)) {
    $where .= " AND l.vehicle_id = ?";
    $params[] = $vehicle_id;
    $types .= "i";
}
if (!empty($route_id)) {
    $where .= " AND l.route_id = ?";
    $params[] = $route_id;
    $types .= "i";
}
if (!empty($date_from)) {
    $where .= " AND l.loading_date >= ?";
    $params[] = $date_from;
    $types .= "s";
}
if (!empty($date_to)) {
    $where .= " AND l.loading_date <= ?";
    $params[] = $date_to;
    $types .= "s";
}

// LOADINGS TOTAL
$loading_sql = "
    SELECT 
        SUM(li.crates_loaded) AS total_crates,
        SUM(li.crates_loaded * s.price_per_crate) AS total_value
    FROM loadings l
    JOIN loading_items li ON l.id = li.loading_id
    JOIN skus s ON li.sku_id = s.id
    $where
";
$stmt = $conn->prepare($loading_sql);
if ($params) $stmt->bind_param($types, ...$params);
$stmt->execute();
$loadings = $stmt->get_result()->fetch_assoc();

// RETURNS TOTAL
$returns_sql = "
    SELECT 
        SUM(r.returned_crates) AS total_return_crates,
        SUM(r.returned_pieces) AS total_return_pieces
    FROM returns r
    JOIN loadings l ON r.delivery_id = l.id
    $where
";
$stmt = $conn->prepare($returns_sql);
if ($params) $stmt->bind_param($types, ...$params);
$stmt->execute();
$returns = $stmt->get_result()->fetch_assoc();

// PAYMENTS TOTAL
$payments_sql = "
    SELECT 
        SUM(bp.cash_amount) + SUM(bp.cheque_amount) + SUM(bp.mpesa_amount) AS total_paid
    FROM bread_payments bp
    JOIN loadings l ON bp.loading_id = l.id
    $where
";
$stmt = $conn->prepare($payments_sql);
if ($params) $stmt->bind_param($types, ...$params);
$stmt->execute();
$payments = $stmt->get_result()->fetch_assoc();

// Calculations
$expected = $loadings['total_value'] ?? 0;
$paid = $payments['total_paid'] ?? 0;
$balance = $expected - $paid;
?>

<div class="main-content container py-4">
    <h4 class="fw-bold text-primary mb-4"><i class="fas fa-chart-bar me-2"></i> Bread Summary Dashboard</h4>

    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <label class="form-label">Vehicle</label>
            <select name="vehicle_id" class="form-select">
                <option value="">All Vehicles</option>
                <?php foreach ($vehicles as $v): ?>
                    <option value="<?= $v['id'] ?>" <?= $vehicle_id == $v['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($v['vehicle_no']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Route</label>
            <select name="route_id" class="form-select">
                <option value="">All Routes</option>
                <?php foreach ($routes as $r): ?>
                    <option value="<?= $r['id'] ?>" <?= $route_id == $r['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($r['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <label class="form-label">From</label>
            <input type="date" name="date_from" class="form-control" value="<?= $date_from ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label">To</label>
            <input type="date" name="date_to" class="form-control" value="<?= $date_to ?>">
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button class="btn btn-primary w-100">🔎 Filter</button>
        </div>
    </form>

    <div class="row g-4">
        <div class="col-md-3">
            <div class="card text-bg-light shadow-sm">
                <div class="card-body">
                    <h6 class="fw-bold text-muted">Total Crates Loaded</h6>
                    <h3><?= number_format($loadings['total_crates'] ?? 0) ?></h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-bg-info shadow-sm">
                <div class="card-body">
                    <h6 class="fw-bold text-white">Expected Value</h6>
                    <h3 class="text-white">Ksh <?= number_format($expected, 2) ?></h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-bg-warning shadow-sm">
                <div class="card-body">
                    <h6 class="fw-bold text-dark">Returned (Crates)</h6>
                    <h4><?= (int)($returns['total_return_crates'] ?? 0) ?> crates + <?= (int)($returns['total_return_pieces'] ?? 0) ?> pcs</h4>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-bg-success shadow-sm">
                <div class="card-body">
                    <h6 class="fw-bold text-white">Payments Collected</h6>
                    <h3 class="text-white">Ksh <?= number_format($paid, 2) ?></h3>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-12 text-center">
            <h5 class="fw-bold <?= $balance > 0 ? 'text-danger' : 'text-success' ?>">
                Balance: Ksh <?= number_format($balance, 2) ?>
            </h5>
        </div>
    </div>
</div>
