<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// CSRF token generation
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$message = '';

// Amount to words function
function convertNumberToWords($number) {
    $hyphen = '-';
    $conjunction = ' and ';
    $separator = ', ';
    $negative = 'negative ';
    $decimal = ' point ';
    $dictionary = [
        0 => 'zero', 1 => 'one', 2 => 'two', 3 => 'three', 4 => 'four',
        5 => 'five', 6 => 'six', 7 => 'seven', 8 => 'eight', 9 => 'nine',
        10 => 'ten', 11 => 'eleven', 12 => 'twelve', 13 => 'thirteen',
        14 => 'fourteen', 15 => 'fifteen', 16 => 'sixteen', 17 => 'seventeen',
        18 => 'eighteen', 19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
        40 => 'forty', 50 => 'fifty', 60 => 'sixty', 70 => 'seventy',
        80 => 'eighty', 90 => 'ninety',
        100 => 'hundred', 1000 => 'thousand', 1000000 => 'million',
        1000000000 => 'billion'
    ];

    if (!is_numeric($number)) return false;
    if ($number < 0) return $negative . convertNumberToWords(abs($number));

    $string = $fraction = null;
    if (strpos($number, '.') !== false) {
        [$number, $fraction] = explode('.', $number);
    }

    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens = ((int)($number / 10)) * 10;
            $units = $number % 10;
            $string = $dictionary[$tens];
            if ($units) $string .= $hyphen . $dictionary[$units];
            break;
        case $number < 1000:
            $hundreds = (int)($number / 100);
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) $string .= $conjunction . convertNumberToWords($remainder);
            break;
        default:
            foreach ([1000000000 => 'billion', 1000000 => 'million', 1000 => 'thousand'] as $base => $word) {
                if ($number >= $base) {
                    $numBaseUnits = (int)($number / $base);
                    $remainder = $number % $base;
                    $string = convertNumberToWords($numBaseUnits) . ' ' . $word;
                    if ($remainder) $string .= $separator . convertNumberToWords($remainder);
                    break;
                }
            }
    }

    if ($fraction && is_numeric($fraction)) {
        $string .= $decimal;
        foreach (str_split((string) $fraction) as $digit) {
            $string .= $dictionary[$digit] . ' ';
        }
    }

    return ucwords($string);
}

// Handle AJAX for amount to words
if (isset($_GET['ajax']) && $_GET['ajax'] == 1 && isset($_GET['num'])) {
    echo convertNumberToWords($_GET['num']) . ' Shillings Only';
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die("Invalid CSRF token.");
    }

    $cheque_leaf_id = (int)$_POST['cheque_leaf_id'];
    $payee_name = trim($_POST['payee_name']);
    $amount = (float)$_POST['amount'];
    $amount_words = convertNumberToWords($amount) . ' Shillings Only';
    $payment_date = $_POST['payment_date'];
    $reason = trim($_POST['reason']);
    $user_id = $_SESSION['user_id'] ?? 1;

    // Fetch serial number and book ID from cheque_leaves
    $stmt = $conn->prepare("SELECT serial_number, cheque_book_id FROM cheque_leaves WHERE id = ? AND status = 'available'");
    $stmt->bind_param("i", $cheque_leaf_id);
    $stmt->execute();
    $stmt->bind_result($serial_number, $cheque_book_id);
    if ($stmt->fetch()) {
        $stmt->close();

        // Insert into cheques table
        $stmt = $conn->prepare("INSERT INTO cheques (cheque_leaf_id, payee_name, amount, amount_words, payment_date, reason, printed_by, status, printed_at) VALUES (?, ?, ?, ?, ?, ?, ?, 'pending', NOW())");
        $stmt->bind_param("isdsssi", $cheque_leaf_id, $payee_name, $amount, $amount_words, $payment_date, $reason, $user_id);
        if ($stmt->execute()) {
            // Mark cheque_leaf as used
            $conn->query("UPDATE cheque_leaves SET status = 'used', issued_to = '$payee_name', issued_date = '$payment_date' WHERE id = $cheque_leaf_id");

            $message = "<div class='alert alert-success'>Cheque issued successfully (Serial #$serial_number)</div>";
        } else {
            $message = "<div class='alert alert-danger'>Failed to issue cheque.</div>";
        }
        $stmt->close();
    } else {
        $message = "<div class='alert alert-warning'>Invalid or already used cheque leaf.</div>";
    }
}
?>

<div class="container mt-4">
    <h4 class="mb-4">Issue New Cheque</h4>
    <?= $message ?>

    <form method="post" class="row g-3">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

        <div class="col-md-6">
            <label for="cheque_leaf_id" class="form-label">Available Cheque Leaf</label>
            <select name="cheque_leaf_id" id="cheque_leaf_id" class="form-select" required>
                <option value="">Select Cheque Leaf</option>
                <?php
                $result = $conn->query("
                    SELECT MIN(cl.id) AS id, cb.book_number, cl.serial_number
                    FROM cheque_leaves cl
                    JOIN cheque_books cb ON cb.id = cl.cheque_book_id
                    WHERE cl.status = 'available'
                    GROUP BY cb.book_number, cl.serial_number
                    ORDER BY cl.serial_number ASC
                ");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='{$row['id']}'>Book: {$row['book_number']} | Serial: {$row['serial_number']}</option>";
                }
                ?>
            </select>
        </div>

        <div class="col-md-6">
            <label for="payee_name" class="form-label">Payee Name</label>
            <input type="text" name="payee_name" id="payee_name" class="form-control" required>
        </div>

        <div class="col-md-4">
            <label for="amount" class="form-label">Amount</label>
            <input type="number" step="0.01" name="amount" id="amount" class="form-control" required>
        </div>

        <div class="col-md-8">
            <label for="amount_words" class="form-label">Amount in Words</label>
            <input type="text" name="amount_words" id="amount_words" class="form-control" readonly required>
        </div>

        <div class="col-md-4">
            <label for="payment_date" class="form-label">Payment Date</label>
            <input type="date" name="payment_date" id="payment_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>

        <div class="col-md-8">
            <label for="reason" class="form-label">Reason / Narration</label>
            <textarea name="reason" id="reason" rows="2" class="form-control"></textarea>
        </div>

        <div class="col-12">
            <button class="btn btn-primary">Issue Cheque</button>
        </div>
    </form>
</div>

<script>
document.getElementById('amount').addEventListener('blur', function () {
    let num = parseFloat(this.value);
    if (!isNaN(num)) {
        fetch('add.php?num=' + num + '&ajax=1')
            .then(res => res.text())
            .then(text => document.getElementById('amount_words').value = text);
    }
});
</script>
