<?php
require_once 'pdo_db.php';

$cheque_id = isset($_GET['cheque_id']) ? (int)$_GET['cheque_id'] : 0;

if (!$cheque_id) {
    die("❌ Missing cheque_id parameter.");
}

// 1. Fetch cheque details
$stmt = $pdo->prepare("
    SELECT c.*, l.leaf_number, cb.layout_id
    FROM cheques c
    JOIN cheque_leaves l ON c.cheque_leaf_id = l.id
    JOIN cheque_books cb ON l.cheque_book_id = cb.id
    WHERE c.id = ?
");
$stmt->execute([$cheque_id]);
$cheque = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cheque) {
    die("❌ Cheque not found.");
}

// 2. Fetch layout
$stmt2 = $pdo->prepare("SELECT * FROM cheque_layouts WHERE id = ?");
$stmt2->execute([$cheque['layout_id']]);
$layout = $stmt2->fetch(PDO::FETCH_ASSOC);

if (!$layout) {
    die("❌ Layout not found for this cheque.");
}

// 3. Fetch layout fields
$stmt3 = $pdo->prepare("SELECT * FROM layout_fields WHERE layout_id = ? AND is_visible = 1");
$stmt3->execute([$cheque['layout_id']]);
$fields = $stmt3->fetchAll(PDO::FETCH_ASSOC);

// 4. Prepare field values
$values = [
    'payee' => $cheque['payee_name'],
    'amount' => number_format($cheque['amount'], 2),
    'amount_words' => $cheque['amount_words'],
    'date' => date('d/m/Y', strtotime($cheque['payment_date'])),
    'ac_payee' => 'A/C PAYEE ONLY'
];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Print Cheque #<?= $cheque['id'] ?></title>
    <style>
        body {
            margin: 0;
            padding: 0;
        }
        .cheque {
            position: relative;
            width: 800px;
            height: 350px;
            background-image: url('../../Uploads/cheque_backgrounds/<?= $layout['background_image'] ?>');
            background-size: cover;
            background-repeat: no-repeat;
            margin: auto;
        }
        .field {
            position: absolute;
            white-space: nowrap;
        }
        @media print {
            body { margin: 0; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="cheque">
        <?php foreach ($fields as $f): ?>
            <div class="field" style="
                left: <?= $f['position_x'] ?>px;
                top: <?= $f['position_y'] ?>px;
                font-size: <?= $f['font_size'] ?>px;
                font-family: <?= $f['font_family'] ?>;
                width: <?= $f['width'] ?>px;
                height: <?= $f['height'] ?>px;
            ">
                <?= htmlspecialchars($values[$f['field_name']] ?? strtoupper($f['field_name'])) ?>
            </div>
        <?php endforeach; ?>
    </div>
</body>
</html>
