<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
  header("Location: add.php");
  exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
  die("CSRF validation failed.");
}

$supplier_id         = (int) $_POST['supplier_id'];
$invoice_id          = isset($_POST['invoice_id']) && $_POST['invoice_id'] ? (int) $_POST['invoice_id'] : null;
$credit_note_number  = trim($_POST['credit_note_number']);
$credit_date         = $_POST['credit_date'];
$amount              = round((float) $_POST['amount'], 2);
$reason              = trim($_POST['reason']);

// Check for duplicates
$check = $conn->prepare("SELECT id FROM credit_notes WHERE supplier_id = ? AND credit_note_number = ? LIMIT 1");
$check->bind_param("is", $supplier_id, $credit_note_number);
$check->execute();
$check->store_result();
if ($check->num_rows > 0) {
  $_SESSION['error'] = "⚠️ This supplier already has that credit note number.";
  header("Location: add.php");
  exit;
}
$check->close();

// File upload
$upload_path = "../../assets/uploads/credit_notes/";
if (!is_dir($upload_path)) {
  mkdir($upload_path, 0755, true);
}

$file_path = null;
if (!empty($_FILES['credit_note_file']['name'])) {
  $ext = strtolower(pathinfo($_FILES['credit_note_file']['name'], PATHINFO_EXTENSION));
  if ($ext !== 'pdf') {
    $_SESSION['error'] = "Only PDF files allowed.";
    header("Location: add.php");
    exit;
  }

  $file_path = uniqid('credit_', true) . '.pdf';
  $full_path = $upload_path . $file_path;

  if (!move_uploaded_file($_FILES['credit_note_file']['tmp_name'], $full_path)) {
    $_SESSION['error'] = "Failed to upload PDF.";
    header("Location: add.php");
    exit;
  }
}

// Insert
$stmt = $conn->prepare("
  INSERT INTO credit_notes (
    supplier_id, credit_note_number, credit_date,
    amount, reason, file_path, invoice_id, created_at
  ) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())
");
$stmt->bind_param("issdssi", $supplier_id, $credit_note_number, $credit_date, $amount, $reason, $file_path, $invoice_id);

if ($stmt->execute()) {
  $_SESSION['success'] = "✅ Credit note saved!";
  header("Location: list.php");
  exit;
} else {
  $_SESSION['error'] = "❌ DB Error: " . $stmt->error;
  header("Location: add.php");
  exit;
}
