<?php
require_once '../../lib/ZKTeco.php';

use ZKTeco\ZKTeco;

$zk = new ZKTeco('192.168.1.247');

try {
    $zk->connect();
    $logs = $zk->getAttendance();

    file_put_contents('attendance_logs.json', json_encode($logs, JSON_PRETTY_PRINT));
    echo "✅ Logs fetched and saved to attendance_logs.json";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
