<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

$current_user = $_SESSION['username'] ?? '';
$current_role = $_SESSION['role'] ?? 'User';
$current_branch = $_SESSION['branch_id'] ?? 0;

// CSRF Token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Get vehicle ID
$vehicle_id = isset($_GET['vehicle_id']) ? intval($_GET['vehicle_id']) : 0;
$vehicle = null;

if ($vehicle_id > 0) {
    $stmt = $conn->prepare("SELECT plate_number FROM vehicles WHERE id = ?");
    $stmt->bind_param("i", $vehicle_id);
    $stmt->execute();

    // ✅ Use bind_result fallback for older PHP setups
    $stmt->bind_result($plate_number);
    if ($stmt->fetch()) {
        $vehicle = ['plate_number' => $plate_number];
    }
    $stmt->close();
}

include_once '../../includes/layout2.php';
?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold text-primary">
            <i class="fas fa-road me-2"></i> Add Trip Log
            <?= $vehicle ? "for <span class='text-dark'>" . htmlspecialchars($vehicle['plate_number']) . "</span>" : '' ?>
        </h4>
        <a href="view_vehicle.php?id=<?= $vehicle_id ?>" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back</a>
    </div>

    <?php if (!$vehicle): ?>
        <div class="alert alert-danger">No vehicle found. Please check the vehicle ID in the URL or add a vehicle first.</div>
    <?php else: ?>
        <form method="POST" action="save_trip.php" class="card shadow p-4">
            <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
            <input type="hidden" name="vehicle_id" value="<?= $vehicle_id ?>">

            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Trip Date *</label>
                    <input type="date" name="trip_date" class="form-control" required value="<?= date('Y-m-d') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Origin *</label>
                    <input type="text" name="origin" class="form-control" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Destination *</label>
                    <input type="text" name="destination" class="form-control" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Distance (KM) *</label>
                    <input type="number" step="0.1" name="distance_km" class="form-control" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Fuel Used (L)</label>
                    <input type="number" step="0.1" name="fuel_used_liters" class="form-control">
                </div>
                <div class="col-md-8">
                    <label class="form-label">Purpose of Trip *</label>
                    <input type="text" name="purpose" class="form-control" required>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Remarks</label>
                    <textarea name="remarks" class="form-control" rows="2"></textarea>
                </div>
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary px-4"><i class="fas fa-save me-1"></i> Save Trip</button>
            </div>
        </form>
    <?php endif; ?>
</div>

<?php include_once '../../includes/footer.php'; ?>
