<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

$current_user = $_SESSION['username'] ?? '';
$current_role = $_SESSION['role'] ?? 'User';
$current_branch = $_SESSION['branch_id'] ?? 0;
$branch_filter = isset($_GET['branch']) ? intval($_GET['branch']) : 0;

// Fetch branches for Admin filter
$branches = [];
if ($current_role === 'Admin') {
    $res = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC");
    while ($row = $res->fetch_assoc()) {
        $branches[] = $row;
    }
}

// Fetch fuel logs with vehicle and branch info
$query = "
SELECT f.*, v.plate_number, b.branch_name
FROM fuel_logs f
JOIN vehicles v ON f.vehicle_id = v.id
LEFT JOIN branches b ON v.branch_id = b.id
WHERE 1=1
";

if ($current_role !== 'Admin') {
    $query .= " AND v.branch_id = $current_branch";
} elseif ($branch_filter > 0) {
    $query .= " AND v.branch_id = $branch_filter";
}

$query .= " ORDER BY f.fuel_date DESC, f.id DESC";
$result = $conn->query($query);

include_once '../../includes/layout2.php';
?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-primary">
            <i class="fas fa-gas-pump me-2"></i> Fuel Logs
        </h4>
        <a href="add_fuel.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Add Fuel Entry</a>
    </div>

    <?php if ($current_role === 'Admin'): ?>
        <form method="GET" class="mb-3">
            <div class="row g-2 align-items-end">
                <div class="col-md-4">
                    <label class="form-label">Filter by Branch</label>
                    <select name="branch" class="form-select select2">
                        <option value="0">-- All Branches --</option>
                        <?php foreach ($branches as $b): ?>
                            <option value="<?= $b['id'] ?>" <?= $branch_filter == $b['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($b['branch_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100"><i class="fas fa-filter"></i> Filter</button>
                </div>
            </div>
        </form>
    <?php endif; ?>

    <div class="card shadow">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-striped" id="fuelTable">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Date</th>
                        <th>Vehicle</th>
                        <th>Station</th>
                        <th>Liters</th>
                        <th>Cost (Ksh)</th>
                        <th>Odometer (km)</th>
                        <th>Branch</th>
                        <th>Remarks</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $sn = 1; while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= $sn++ ?></td>
                            <td><?= htmlspecialchars($row['fuel_date']) ?></td>
                            <td><strong><?= htmlspecialchars($row['plate_number']) ?></strong></td>
                            <td><?= htmlspecialchars($row['station']) ?></td>
                            <td><?= number_format($row['liters'], 1) ?></td>
                            <td><?= number_format($row['cost'], 2) ?></td>
                            <td><?= $row['odometer'] ? number_format($row['odometer'], 0) : '-' ?></td>
                            <td><?= htmlspecialchars($row['branch_name'] ?? '-') ?></td>
                            <td><?= nl2br(htmlspecialchars($row['remarks'])) ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include_once '../../includes/footer.php'; ?>

<!-- DataTables & Select2 -->
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function () {
        $('#fuelTable').DataTable({
            pageLength: 10,
            order: [[1, 'desc']]
        });
        $('.select2').select2();
    });
</script>
