<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: list_vehicles.php");
    exit();
}

// CSRF validation
if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION['error'] = "CSRF token mismatch.";
    header("Location: list_vehicles.php");
    exit();
}

$vehicle_id = intval($_POST['vehicle_id']);
$driver_id = isset($_POST['driver_id']) && $_POST['driver_id'] !== '' ? intval($_POST['driver_id']) : null;

if ($vehicle_id <= 0) {
    $_SESSION['error'] = "Invalid vehicle.";
    header("Location: list_vehicles.php");
    exit();
}

if ($driver_id !== null) {
    $stmt = $conn->prepare("UPDATE vehicles SET assigned_driver_id = ? WHERE id = ?");
    $stmt->bind_param("ii", $driver_id, $vehicle_id);
} else {
    $stmt = $conn->prepare("UPDATE vehicles SET assigned_driver_id = NULL WHERE id = ?");
    $stmt->bind_param("i", $vehicle_id);
}

if ($stmt->execute()) {
    $_SESSION['success'] = "Driver assignment updated successfully.";
} else {
    $_SESSION['error'] = "Error assigning driver.";
}
$stmt->close();

header("Location: list_vehicles.php");
exit();
