<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

// CSRF Check
if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION['error'] = "Invalid CSRF token.";
    header("Location: maintenance_logs.php");
    exit();
}

$vehicle_id     = intval($_POST['vehicle_id'] ?? 0);
$maintenance_date = $_POST['maintenance_date'] ?? '';
$service_type   = trim($_POST['service_type'] ?? '');
$garage_name    = trim($_POST['garage_name'] ?? '');
$cost           = floatval($_POST['cost'] ?? 0);
$odometer       = floatval($_POST['odometer'] ?? 0);
$remarks        = trim($_POST['remarks'] ?? '');
$created_by     = $_SESSION['username'] ?? 'system';

if (!$vehicle_id || !$maintenance_date || !$service_type) {
    $_SESSION['error'] = "All required fields must be filled.";
    header("Location: add_maintenance.php?vehicle_id=$vehicle_id");
    exit();
}

$stmt = $conn->prepare("
    INSERT INTO maintenance_logs (vehicle_id, maintenance_date, service_type, garage_name, cost, odometer, remarks, created_by)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

$stmt->bind_param("isssdiss", $vehicle_id, $maintenance_date, $service_type, $garage_name, $cost, $odometer, $remarks, $created_by);

if ($stmt->execute()) {
    $_SESSION['success'] = "Maintenance log saved successfully.";
    header("Location: maintenance_logs.php");
} else {
    $_SESSION['error'] = "Failed to save maintenance log.";
    header("Location: add_maintenance.php?vehicle_id=$vehicle_id");
}

$stmt->close();
$conn->close();
