<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
  header("Location: list.php");
  exit;
}

// CSRF Check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
  die("CSRF validation failed.");
}

// Inputs
$id                = (int) $_POST['id'];
$supplier_id       = (int) $_POST['supplier_id'];
$branch_id         = (int) $_POST['branch_id'];
$invoice_no        = trim($_POST['invoice_number']);
$invoice_date      = $_POST['invoice_date'];
$invoice_amount    = round((float) $_POST['total_invoice_amount'], 2);
$zero_rated        = round((float) $_POST['zero_rated_amount'], 2);
$vatable_amount    = round((float) $_POST['vatable_amount'], 2);
$vat_amount        = round((float) $_POST['vat_amount'], 2);
$withholding_tax   = round((float) $_POST['withholding_tax'], 2);
$total_with_vat    = round((float) $_POST['total_with_vat'], 2);
$total_payable     = round((float) $_POST['total_payable'], 2);
$vat_inclusion     = $_POST['vat_inclusion'] === 'inclusive' ? 'inclusive' : 'exclusive';

// Check for duplicate (exclude current record)
$check = $conn->prepare("
  SELECT id FROM invoices 
  WHERE supplier_id = ? AND invoice_number = ? AND id != ?
  LIMIT 1
");
$check->bind_param("isi", $supplier_id, $invoice_no, $id);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
  $_SESSION['error'] = "⚠️ This supplier already has another invoice with number '$invoice_no'.";
  header("Location: edit.php?id=$id");
  exit;
}

// File handling if new file uploaded
$invoice = $conn->query("SELECT file_path FROM invoices WHERE id = $id")->fetch_assoc();
$current_file = $invoice['file_path'];
$targetDir = "../../assets/uploads/invoices/";
$new_file = $current_file;

if (isset($_FILES['invoice_file']) && $_FILES['invoice_file']['error'] === UPLOAD_ERR_OK) {
  $uploaded = $_FILES['invoice_file'];
  $ext = strtolower(pathinfo($uploaded['name'], PATHINFO_EXTENSION));

  if ($ext !== 'pdf') {
    die("Only PDF files are allowed.");
  }

  $new_file = uniqid('inv_', true) . '.' . $ext;
  $targetPath = $targetDir . $new_file;

  if (!move_uploaded_file($uploaded['tmp_name'], $targetPath)) {
    die("Failed to upload new invoice file.");
  }

  // Optional: unlink old file
  $old_path = $targetDir . $current_file;
  if (file_exists($old_path)) unlink($old_path);
}

// Update invoice
$stmt = $conn->prepare("
  UPDATE invoices SET 
    supplier_id = ?, branch_id = ?, invoice_number = ?, invoice_date = ?,
    total_amount = ?, zero_rated_amount = ?, vatable_amount = ?,
    vat_amount = ?, withholding_tax = ?, total_with_vat = ?, total_payable = ?,
    vat_type = ?, file_path = ?, updated_at = NOW()
  WHERE id = ?
");

$stmt->bind_param(
  "iissddddddsssi",
  $supplier_id, $branch_id, $invoice_no, $invoice_date,
  $invoice_amount, $zero_rated, $vatable_amount,
  $vat_amount, $withholding_tax, $total_with_vat, $total_payable,
  $vat_inclusion, $new_file, $id
);

if ($stmt->execute()) {
  $_SESSION['success'] = "✅ Invoice updated successfully.";
  header("Location: view.php?id=$id");
  exit;
} else {
  die("❌ Failed to update invoice: " . $stmt->error);
}
