<?php
session_start();
require_once '../../config/db.php';

$id = $_GET['id'] ?? 0;

// Fetch merchandiser
$stmt = $conn->prepare("SELECT * FROM merchandisers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$merch = $result->fetch_assoc();

if (!$merch) {
    $_SESSION['error'] = "Merchandiser not found.";
    header("Location: list_merchandisers.php");
    exit;
}

// Get suppliers
$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name");

include '../../includes/layout2.php';
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-user-edit"></i> Edit Merchandiser</h4>

  <form method="POST" action="update_merchandiser.php" class="card shadow-sm p-4 bg-white">
    <input type="hidden" name="id" value="<?= $merch['id'] ?>">

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Full Name</label>
        <input type="text" name="full_name" class="form-control" required value="<?= htmlspecialchars($merch['full_name']) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">ID Number</label>
        <input type="text" name="id_number" class="form-control" required value="<?= htmlspecialchars($merch['id_number']) ?>">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Phone</label>
        <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($merch['phone']) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">Supplier</label>
        <select name="supplier_id" class="form-select" required>
          <option value="">-- Select Supplier --</option>
          <?php while ($s = $suppliers->fetch_assoc()): ?>
            <option value="<?= $s['id'] ?>" <?= $s['id'] == $merch['supplier_id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($s['name']) ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
    </div>

    <div class="mb-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="Active" <?= $merch['status'] === 'Active' ? 'selected' : '' ?>>Active</option>
        <option value="Inactive" <?= $merch['status'] === 'Inactive' ? 'selected' : '' ?>>Inactive</option>
      </select>
    </div>

    <div class="text-end">
      <button type="submit" class="btn btn-success"><i class="fas fa-save me-1"></i> Update</button>
      <a href="list_merchandisers.php" class="btn btn-secondary ms-2">Cancel</a>
    </div>
  </form>
</div>
