<?php
session_start();
require_once '../../config/db.php';

// CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Fetch branches
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name");

include '../../includes/layout2.php';
?>

<div class="main-content">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-id-badge"></i> Merchandiser Check-In / Check-Out</h4>

    <?php if (isset($_SESSION['merch_msg'])): ?>
        <div class="toast-container position-fixed top-0 end-0 p-3">
            <div class="toast show align-items-center text-white bg-info border-0" role="alert">
                <div class="d-flex">
                    <div class="toast-body">
                        <?= $_SESSION['merch_msg'] ?>
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                </div>
            </div>
        </div>
        <?php unset($_SESSION['merch_msg']); ?>
    <?php endif; ?>

    <form id="merchForm" action="save_log.php" method="POST" class="card p-4 shadow-sm bg-white" target="badgeFrame">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

        <div class="row mb-3">
            <div class="col-md-4">
                <label class="form-label">ID Number</label>
                <input type="text" name="id_number" id="id_number" class="form-control" required>
            </div>

            <div class="col-md-4">
                <label class="form-label">Branch</label>
                <select name="branch_id" id="branch_id" class="form-select" required>
                    <option value="">-- Select Branch --</option>
                    <?php while ($b = $branches->fetch_assoc()): ?>
                        <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['branch_name']) ?></option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">Action</label>
                <div class="d-flex">
                    <button type="button" class="btn btn-success me-2 w-100" onclick="confirmAction('IN')">
                        <i class="fas fa-sign-in-alt me-1"></i> Log In
                    </button>
                    <button type="button" class="btn btn-danger w-100" onclick="confirmAction('OUT')">
                        <i class="fas fa-sign-out-alt me-1"></i> Log Out
                    </button>
                </div>
            </div>
        </div>
        <input type="hidden" name="log_type" id="log_type">
    </form>

    <iframe name="badgeFrame" style="display: none;"></iframe>
</div>

<!-- Confirmation Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Confirm Action</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="confirmMessage"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmSubmit">
                    <span class="spinner-border spinner-border-sm d-none" id="spinner"></span>
                    <span id="proceedText">Proceed</span>
                </button>
            </div>
        </div>
    </div>
</div>

<script>
let selectedAction = '';

function confirmAction(action) {
    const idNumber = document.getElementById('id_number').value.trim();
    const branchId = document.getElementById('branch_id').value;

    if (!idNumber || !branchId) {
        alert('Please enter ID Number and select a branch.');
        return;
    }

    selectedAction = action;

    fetch('check_status.php?id_number=' + encodeURIComponent(idNumber))
        .then(response => response.json())
        .then(data => {
            let messageIcon = '';
            let messageText = (action === 'IN')
                ? 'Are you sure you want to <strong>Log In</strong>?'
                : 'Are you sure you want to <strong>Log Out</strong>?';

            let allowProceed = true;

            if (action === 'IN' && data.logged_in && data.branch_id != branchId) {
                messageIcon = `<div class="text-danger mb-2" style="font-size:2rem;">⚠️</div>`;
                messageText += `<br><span class="text-danger">Warning: Already logged in at <strong>${data.branch_name}</strong>!</span>`;
            }

            if (action === 'OUT') {
                if (!data.logged_in) {
                    messageIcon = `<div class="text-danger mb-2" style="font-size:2rem;">❌</div>`;
                    messageText += `<br><span class="text-danger">You are not currently logged in anywhere. Cannot log out.</span>`;
                    allowProceed = false;
                } else if (data.branch_id != branchId) {
                    messageIcon = `<div class="text-danger mb-2" style="font-size:2rem;">⚠️</div>`;
                    messageText += `<br><span class="text-warning">Note: You are logged in at <strong>${data.branch_name}</strong>, but logging out here will still proceed.</span>`;
                }
            }

            document.getElementById('confirmMessage').innerHTML = messageIcon + messageText;

            const confirmButton = document.getElementById('confirmSubmit');
            confirmButton.disabled = !allowProceed;

            confirmButton.onclick = function () {
                if (!allowProceed) return;

                const spinner = document.getElementById('spinner');
                const proceedText = document.getElementById('proceedText');

                confirmButton.disabled = true;
                spinner.classList.remove('d-none');
                proceedText.textContent = 'Processing...';

                document.getElementById('log_type').value = selectedAction;
                document.getElementById('merchForm').submit();

                setTimeout(() => {
                    confirmButton.disabled = false;
                    spinner.classList.add('d-none');
                    proceedText.textContent = 'Proceed';
                }, 2000);
            };

            const confirmModal = new bootstrap.Modal(document.getElementById('confirmModal'));
            confirmModal.show();
        })
        .catch(() => {
            alert('Error checking merchandiser status.');
        });
}
</script>

<?php if (isset($_GET['badge']) && is_numeric($_GET['badge'])): ?>
<script>
window.open('print_badge.php?log_id=<?= $_GET['badge'] ?>', '_blank', 'width=400,height=600');
</script>
<?php endif; ?>
