<?php
session_start();
require_once __DIR__ . '/../../config/db.php';


require_once __DIR__ . '/../../includes/functions.php';


// Fetch all clients
$stmt = $conn->prepare("SELECT * FROM newspaper_clients ORDER BY client_name");
$stmt->execute();
$clients = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Newspaper Clients - SmartPay360</title>
  <link href="../assets/css/style.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
  <h2 class="mb-4">📬 Newspaper Clients</h2>

  <form method="POST" action="save_client.php" class="row g-3">
    <div class="col-md-4">
      <input type="text" name="client_name" class="form-control" placeholder="Client Name" required>
    </div>
    <div class="col-md-3">
      <input type="text" name="contact" class="form-control" placeholder="Contact Info">
    </div>
    <div class="col-md-3">
      <input type="text" name="location" class="form-control" placeholder="Location">
    </div>
    <div class="col-md-2">
      <button class="btn btn-primary w-100">Add Client</button>
    </div>
  </form>

  <hr>

  <table class="table table-bordered table-striped mt-4">
    <thead class="table-dark">
      <tr>
        <th>#</th>
        <th>Client Name</th>
        <th>Contact</th>
        <th>Location</th>
        <th>Status</th>
      </tr>
    </thead>
    <tbody>
      <?php $i = 1; while ($row = $clients->fetch_assoc()): ?>
      <tr>
        <td><?= $i++ ?></td>
        <td><?= htmlspecialchars($row['client_name']) ?></td>
        <td><?= htmlspecialchars($row['contact']) ?></td>
        <td><?= htmlspecialchars($row['location']) ?></td>
        <td><?= $row['status'] == 'active' ? '✅ Active' : '❌ Inactive' ?></td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</body>
</html>
