<?php
session_start();
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/newspaper_functions.php';
include __DIR__ . '/../../includes/layout2.php';

$query = "SELECT * FROM newspaper_dispatch ORDER BY date DESC";
$result = $conn->query($query);
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-chart-line"></i> Dispatch Report</h4>

  <div class="card shadow-sm">
    <div class="card-body table-responsive">
      <table class="table table-bordered table-striped">
        <thead class="table-dark">
          <tr>
            <th>Date</th>
            <th>Customer</th>
            <th>Newspaper</th>
            <th>Quantity</th>
            <th>Collected By</th>
            <th>Remarks</th>
          </tr>
        </thead>
        <tbody>
          <?php while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= getCustomerName($conn, $row['customer_id']) ?></td>
            <td><?= getNewspaperTitle($conn, $row['newspaper_id']) ?></td>
            <td><?= htmlspecialchars($row['quantity']) ?></td>
            <td><?= htmlspecialchars($row['collected_by']) ?></td>
            <td><?= htmlspecialchars($row['remarks']) ?></td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
