<?php
session_start();
require_once __DIR__ . '/../../config/db.php';
include __DIR__ . '/../../includes/layout2.php';

$query = "SELECT * FROM newspaper_titles ORDER BY title";
$result = $conn->query($query);
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-newspaper"></i> Newspaper Titles</h4>

  <a href="add_title.php" class="btn btn-success mb-3"><i class="fas fa-plus-circle me-1"></i> Add New Title</a>

  <div class="card shadow-sm">
    <div class="card-body table-responsive">
      <table class="table table-bordered table-striped">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Title</th>
            <th>Category</th>
            <th>Supplier</th>
            <th>Price per Copy</th>
          </tr>
        </thead>
        <tbody>
          <?php $i = 1; while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td><?= htmlspecialchars($row['title']) ?></td>
            <td><?= htmlspecialchars($row['category']) ?></td>
            <td><?= htmlspecialchars($row['supplier']) ?></td>
            <td>KSh <?= number_format($row['price_per_copy'], 2) ?></td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
