CREATE TABLE newspaper_titles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    category VARCHAR(100),
    supplier VARCHAR(255),
    price_per_copy DECIMAL(10,2),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE newspaper_customers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    type ENUM('Vendor', 'Retailer', 'Office', 'Individual'),
    contact VARCHAR(100),
    usual_pickup_time TIME,
    branch_id INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE newspaper_dispatch (
    id INT AUTO_INCREMENT PRIMARY KEY,
    date DATE NOT NULL,
    customer_id INT NOT NULL,
    newspaper_id INT NOT NULL,
    quantity INT NOT NULL,
    collected_by VARCHAR(255),
    remarks TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (customer_id) REFERENCES newspaper_customers(id),
    FOREIGN KEY (newspaper_id) REFERENCES newspaper_titles(id)
);

CREATE TABLE newspaper_collections (
    id INT AUTO_INCREMENT PRIMARY KEY,
    dispatch_id INT NOT NULL,
    quantity_collected INT,
    payment_received ENUM('Y', 'N') DEFAULT 'N',
    amount_paid DECIMAL(10,2),
    payment_method ENUM('Cash', 'MPESA', 'Credit'),
    collected_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (dispatch_id) REFERENCES newspaper_dispatch(id)
);