<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$summary = $_SESSION['payment_summary'] ?? [];
$paid_invoices = $_SESSION['paid_invoices'] ?? [];
$success = $_SESSION['success'] ?? 'Payment recorded successfully.';

unset($_SESSION['payment_summary'], $_SESSION['paid_invoices'], $_SESSION['success']);

$totalAmount = array_sum(array_column($summary, 'amount'));
$totalAllocated = array_sum(array_column($paid_invoices, 'amount'));

$datePrinted = date('Y-m-d H:i');
$supplier_name = $_SESSION['last_supplier_name'] ?? 'Supplier';
$branch_name = $_SESSION['user']['branch_name'] ?? 'Branch';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Remittance Receipt</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @page { size: 80mm auto; margin: 0; }
    body { width: 80mm; font-family: Arial, sans-serif; font-size: 13px; margin: 0; padding: 5px; color: #000; }
    .center { text-align: center; }
    .bold { font-weight: bold; }
    .line { border-top: 2px dashed #000; margin: 10px 0; }
    table { width: 100%; border-collapse: collapse; font-size: 12px; }
    td { padding: 3px 0; vertical-align: top; }
    .summary { margin-top: 10px; }
    .signature-area { margin-top: 20px; }
    .small-text { font-size: 11px; text-align: center; margin-top: 15px; }
    .text-end { text-align: right; }
    @media print { body { zoom: 1.6; } }
  </style>
</head>

<body>
<div class="container">

  <!-- SUCCESS MODAL -->
  <div class="modal fade show" id="successModal" tabindex="-1" style="display: block; background-color: rgba(0,0,0,0.6);" aria-modal="true" role="dialog">
    <div class="modal-dialog modal-sm modal-dialog-centered">
      <div class="modal-content text-center">
        <div class="modal-body">
          <div class="mb-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="45" height="45" fill="#28a745" class="bi bi-check-circle-fill" viewBox="0 0 16 16">
              <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM6.97 11.03a.75.75 0 0 0 1.07 0l3.992-3.992a.75.75 0 0 0-1.06-1.06L7.5 9.439 6.03 7.97a.75.75 0 1 0-1.06 1.06l1.999 2z"/>
            </svg>
          </div>
          <h5 class="mb-2 text-success"><?= htmlspecialchars($success) ?></h5>
          <p class="text-muted small">Printing receipt...</p>
        </div>
      </div>
    </div>
  </div>

  <!-- Header -->
  <div class="center mt-2">
    <h3>SMARTPAY360</h3>
    <strong><?= strtoupper($branch_name) ?></strong><br>
    <span class="bold"><?= strtoupper($supplier_name) ?></span><br>
    <div class="line"></div>
    <p class="bold">SUPPLIER PAYMENT RECEIPT</p>
  </div>

  <!-- Date -->
  <p>
    <strong>Date:</strong> <?= $datePrinted ?><br>
  </p>

  <div class="line"></div>

  <!-- Payment Breakdown -->
  <?php if (!empty($summary)): ?>
    <p><strong>Payment Breakdown:</strong></p>
    <table>
      <?php foreach ($summary as $pay): ?>
        <tr>
          <td><?= strtoupper($pay['mode']) ?> <?= $pay['ref'] ? " (Ref: " . htmlspecialchars($pay['ref']) . ")" : "" ?></td>
          <td class="text-end">Ksh <?= number_format($pay['amount'], 2) ?></td>
        </tr>
      <?php endforeach; ?>
      <tr class="bold">
        <td class="text-end">Total Paid:</td>
        <td class="text-end">Ksh <?= number_format($totalAmount, 2) ?></td>
      </tr>
    </table>
  <?php endif; ?>

  <div class="line"></div>

  <!-- Invoice Allocations -->
  <?php if (!empty($paid_invoices)): ?>
    <p><strong>Allocated Invoices:</strong></p>
    <table>
      <?php foreach ($paid_invoices as $inv): ?>
        <tr>
          <td>#INV<?= str_pad($inv['invoice_id'], 5, '0', STR_PAD_LEFT) ?></td>
          <td class="text-end">Ksh <?= number_format($inv['amount'], 2) ?></td>
        </tr>
      <?php endforeach; ?>
      <tr class="bold">
        <td class="text-end">Total Allocated:</td>
        <td class="text-end">Ksh <?= number_format($totalAllocated, 2) ?></td>
      </tr>
    </table>
  <?php endif; ?>

  <div class="line"></div>

  <!-- Summary & Signatures -->
  <div class="summary">
    <p><strong>Processed By:</strong> <?= $_SESSION['user']['name'] ?? 'System User' ?></p>
  </div>

  <div class="signature-area">
    ___________________________<br>
    Authorized Signature
  </div>

  <div class="signature-area">
    ___________________________<br>
    Supplier / Receiver Signature
  </div>

  <div class="small-text">
    Printed via SmartPay360 • <?= date('Y-m-d H:i') ?>
  </div>

</div>

<script>
  setTimeout(() => {
    document.getElementById('successModal').style.display = 'none';
    window.print();
  }, 2000);
</script>

</body>
</html>
