<?php
session_start();
require_once '../../config/db.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    $_SESSION['error'] = "Invalid transaction.";
    header('Location: list.php');
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $till_number = trim($_POST['till_number']);
    $payout_number = trim($_POST['payout_number']);

    if (empty($till_number) || empty($payout_number)) {
        $_SESSION['error'] = "Both Till Number and Payout Number are required.";
    } else {
        $update = $conn->prepare("UPDATE petty_cash_transactions SET till_number = ?, payout_number = ?, status = 'approved' WHERE id = ?");
        $update->bind_param("ssi", $till_number, $payout_number, $id);

        if ($update->execute()) {
            $_SESSION['success'] = "Transaction approved with manual payment details.";
            header("Location: list.php");
            exit;
        } else {
            $_SESSION['error'] = "Failed to save payment details.";
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Enter Payment Details</title>
    <link href="../../assets/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-5">
    <h3>Enter Payment Details</h3>
    <?php if (!empty($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>
    <form method="post">
        <div class="mb-3">
            <label for="till_number" class="form-label">Till Number</label>
            <input type="text" class="form-control" name="till_number" id="till_number" required>
        </div>
        <div class="mb-3">
            <label for="payout_number" class="form-label">Payout Number</label>
            <input type="text" class="form-control" name="payout_number" id="payout_number" required>
        </div>
        <button type="submit" class="btn btn-primary">Approve Transaction</button>
        <a href="list.php" class="btn btn-secondary">Cancel</a>
    </form>
</body>
</html>
