```php
<?php
require_once '../../config/db.php';
header('Content-Type: application/json');

$branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : null;
$query = "
    SELECT pct.id, b.branch_name, pct.type, pct.amount, pct.description, 
           pct.reference_no, DATE_FORMAT(pct.transaction_date, '%d-%b-%Y') AS transaction_date, 
           u.username AS created_by, pct.status, au.username AS approved_by
    FROM petty_cash_transactions pct
    JOIN branches b ON pct.branch_id = b.id
    JOIN users u ON pct.created_by = u.id
    LEFT JOIN users au ON pct.approved_by = au.id
";
$params = [];
if ($branch_id !== null) {
    $query .= " WHERE pct.branch_id = ?";
    $params[] = $branch_id;
}
$query .= " ORDER BY pct.transaction_date DESC, pct.created_at DESC";

$stmt = $conn->prepare($query);
if (!$stmt) {
    error_log("Prepare failed: " . $conn->error);
    echo json_encode(['error' => 'Database error']);
    exit;
}
if ($branch_id !== null) {
    $stmt->bind_param("i", $branch_id);
}
$stmt->execute();
$result = $stmt->get_result();

$transactions = [];
while ($row = $result->fetch_assoc()) {
    $transactions[] = $row;
}

echo json_encode(['transactions' => $transactions]);
exit;
```