<?php
session_start();
require_once '../../includes/layout.php';
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $promo_name = $_POST['promo_name'];
    $description = $_POST['description'];
    $stmt = $conn->prepare("INSERT INTO promotions (promo_name, description, start_date, end_date, active) VALUES (?, ?, NOW(), NOW(), 1)");
    $stmt->bind_param("ss", $promo_name, $description);
    $stmt->execute();
    $_SESSION['success'] = 'Promotion uploaded!';
    header('Location: upload_promo.php');
    exit;
}
?>

<div class="container mt-4">
    <h2>Quick Upload Promo</h2>
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <form method="post">
        <div class="mb-3">
            <label>Promotion Name</label>
            <input type="text" name="promo_name" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Description</label>
            <textarea name="description" class="form-control" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Upload</button>
    </form>
</div>
