<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$account_id = $_GET['account_id'] ?? '';
$date_from = $_GET['date_from'] ?? '';
$date_to = $_GET['date_to'] ?? '';

// Load accounts
$accounts = $conn->query("SELECT id, bank_name, account_number FROM bank_accounts WHERE 1 ORDER BY bank_name");

// Fetch transactions and match to payments
$where = "1";
$params = [];

if ($account_id !== '') {
    $where .= " AND bt.bank_account_id = ?";
    $params[] = $account_id;
}
if ($date_from !== '') {
    $where .= " AND bt.trans_date >= ?";
    $params[] = $date_from;
}
if ($date_to !== '') {
    $where .= " AND bt.trans_date <= ?";
    $params[] = $date_to;
}

$sql = "
  SELECT 
    bt.id, bt.trans_date, bt.amount, bt.reference_no, bt.remarks,
    ba.bank_name, ba.account_number,
    p.id AS payment_id, p.supplier_id, s.name AS supplier_name, p.method, p.reference_no AS system_ref
  FROM bank_transactions bt
  JOIN bank_accounts ba ON bt.bank_account_id = ba.id
  LEFT JOIN payments p ON bt.matched_payment_id = p.id
  LEFT JOIN suppliers s ON p.supplier_id = s.id
  WHERE $where
  ORDER BY bt.trans_date DESC
";

$stmt = $conn->prepare($sql);
if ($params) {
    $types = str_repeat("s", count($params));
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

$rows = [];
while ($row = $result->fetch_assoc()) {
    $rows[] = $row;
}
?>

<div class="container mt-4">
  <h4 class="text-primary mb-3"><i class="fas fa-university"></i> Bank Reconciliation</h4>

  <form method="get" class="row g-3 mb-4">
    <div class="col-md-4">
      <label>Bank Account</label>
      <select name="account_id" class="form-select">
        <option value="">-- All Accounts --</option>
        <?php foreach ($accounts as $a): ?>
          <option value="<?= $a['id'] ?>" <?= $account_id == $a['id'] ? 'selected' : '' ?>>
            <?= $a['bank_name'] ?> (<?= $a['account_number'] ?>)
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label>Date From</label>
      <input type="date" name="date_from" value="<?= $date_from ?>" class="form-control">
    </div>
    <div class="col-md-3">
      <label>Date To</label>
      <input type="date" name="date_to" value="<?= $date_to ?>" class="form-control">
    </div>
    <div class="col-md-2 d-grid">
      <label>&nbsp;</label>
      <button class="btn btn-primary">Filter</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-hover table-bordered small">
      <thead class="table-dark">
        <tr>
          <th>Date</th>
          <th>Bank Ref</th>
          <th>Bank Amount</th>
          <th>Bank Remarks</th>
          <th>Status</th>
          <th>Matched Payment</th>
          <th>Supplier</th>
          <th>Method</th>
          <th>SmartPay Ref</th>
        </tr>
      </thead>
      <tbody>
        <?php if (count($rows) > 0): ?>
          <?php foreach ($rows as $r): ?>
            <tr class="<?= $r['payment_id'] ? '' : 'table-warning' ?>">
              <td><?= date('d-M-Y', strtotime($r['trans_date'])) ?></td>
              <td><?= htmlspecialchars($r['reference_no']) ?></td>
              <td class="text-end text-primary">KSh <?= number_format($r['amount'], 2) ?></td>
              <td><?= htmlspecialchars($r['remarks']) ?></td>
              <td class="text-center">
                <?= $r['payment_id'] ? '<span class="badge bg-success">Matched</span>' : '<span class="badge bg-danger">Unmatched</span>' ?>
              </td>
              <td class="text-center">
                <?= $r['payment_id'] ? "<a href='../payments/view.php?id={$r['payment_id']}' class='text-primary'>#{$r['payment_id']}</a>" : '—' ?>
              </td>
              <td><?= htmlspecialchars($r['supplier_name'] ?? '—') ?></td>
              <td><?= htmlspecialchars($r['method'] ?? '—') ?></td>
              <td><?= htmlspecialchars($r['system_ref'] ?? '—') ?></td>
            </tr>
          <?php endforeach; ?>
        <?php else: ?>
          <tr><td colspan="9" class="text-center text-muted">No bank transactions found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
