<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Initialize filters
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;
$branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : 0;

$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);

// Build query
$query = "
    SELECT s.name AS supplier_name, b.branch_name, 
           SUM(i.vatable_amount) AS total_vatable, 
           SUM(i.vat_amount) AS total_vat, 
           SUM(i.withholding_tax) AS total_wht
    FROM invoices i
    JOIN suppliers s ON i.supplier_id = s.id
    JOIN branches b ON i.branch_id = b.id
    WHERE i.invoice_date BETWEEN ? AND ?
";
$params = [$start_date, $end_date];
$types = "ss";

if ($supplier_id > 0) {
    $query .= " AND i.supplier_id = ?";
    $params[] = $supplier_id;
    $types .= "i";
}
if ($branch_id > 0) {
    $query .= " AND i.branch_id = ?";
    $params[] = $branch_id;
    $types .= "i";
}
$query .= " GROUP BY s.id, s.name, b.id, b.branch_name ORDER BY s.name, b.branch_name";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$report_data = $result->fetch_all(MYSQLI_ASSOC);

// Calculate totals
$total_vatable = 0;
$total_vat = 0;
$total_wht = 0;
foreach ($report_data as $row) {
    $total_vatable += $row['total_vatable'];
    $total_vat += $row['total_vat'];
    $total_wht += $row['total_wht'];
}
?>

<style>
.table-responsive {
    position: relative;
    max-height: 500px; /* Adjust as needed */
    overflow-y: auto;
}
.table tfoot tr {
    position: sticky;
    bottom: 0;
    z-index: 1;
    background-color: #343a40; /* Match table-dark */
    color: white; /* Explicitly set text to white */
}
</style>

<div class="main-content">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-calculator me-2"></i>Tax Summary Report</h4>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Supplier</label>
                    <select name="supplier_id" class="form-select">
                        <option value="0">All Suppliers</option>
                        <?php foreach ($suppliers as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= $s['id'] == $supplier_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($s['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Branch</label>
                    <select name="branch_id" class="form-select">
                        <option value="0">All Branches</option>
                        <?php foreach ($branches as $b): ?>
                            <option value="<?= $b['id'] ?>" <?= $b['id'] == $branch_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($b['branch_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-12 text-end">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-1"></i>Apply Filters</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Table -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-dark">
                    <tr class="text-center">
                        <th>Supplier</th>
                        <th>Branch</th>
                        <th>VATable Amount (KES)</th>
                        <th>VAT (KES)</th>
                        <th>Withholding Tax (KES)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($report_data): ?>
                        <?php foreach ($report_data as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['supplier_name']) ?></td>
                                <td><?= htmlspecialchars($row['branch_name']) ?></td>
                                <td class="text-end">KSh <?= number_format($row['total_vatable'], 2) ?></td>
                                <td class="text-end">KSh <?= number_format($row['total_vat'], 2) ?></td>
                                <td class="text-end">KSh <?= number_format($row['total_wht'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="5" class="text-center text-muted">No tax data found.</td></tr>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr class="text-center">
                        <td colspan="2"><strong>Totals</strong></td>
                        <td><strong>KSh <?= number_format($total_vatable, 2) ?></strong></td>
                        <td><strong>KSh <?= number_format($total_vat, 2) ?></strong></td>
                        <td><strong>KSh <?= number_format($total_wht, 2) ?></strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>