<?php
session_start();
require_once '../../config/db.php';

function abort_to_add($m){ $_SESSION['error']=$m; header('Location: add.php'); exit; }
if (($_POST['csrf_token'] ?? '') !== ($_SESSION['csrf_token'] ?? '')) abort_to_add('Invalid session token.');

$note_type   = $_POST['note_type'] ?? '';
$cn_number   = trim($_POST['credit_note_number'] ?? '');
$supplier_id = (int)($_POST['supplier_id'] ?? 0);
$branch_id   = (int)($_POST['branch_id'] ?? 0);
$invoice_id  = $_POST['invoice_id'] !== '' ? (int)$_POST['invoice_id'] : null;
$credit_date = $_POST['credit_date'] ?? date('Y-m-d');
$reason      = $_POST['reason'] ?? '';
$desc        = $_POST['description_note'] ?? '';
$created_by  = (int)($_POST['created_by'] ?? 0);

$sku   = $_POST['sku'] ?? [];
$name  = $_POST['item_name'] ?? [];
$unit  = $_POST['unit'] ?? [];
$qty   = $_POST['qty'] ?? [];
$price = $_POST['unit_price'] ?? [];
$vat   = $_POST['vat_rate'] ?? [];

if (!$note_type || !$cn_number || !$supplier_id || !$credit_date || !$reason || !$branch_id) abort_to_add('Missing required fields.');
if (!count($name)) abort_to_add('Add at least one item.');

$upload_path = null;
if (!empty($_FILES['credit_note_file']['name'])) {
  $dir = __DIR__ . '/../../uploads/credit_notes/'; if (!is_dir($dir)) @mkdir($dir,0775,true);
  $fname = $cn_number.'_'.time().'.pdf';
  if (!move_uploaded_file($_FILES['credit_note_file']['tmp_name'], $dir.$fname)) abort_to_add('Failed to upload PDF.');
  $upload_path = 'uploads/credit_notes/'.$fname;
}

$conn->begin_transaction();
try {
  $subtotal=0; $vat_amount=0; $total=0; $lines=[];
  for($i=0;$i<count($name);$i++){
    $q=(float)($qty[$i]??0); $p=(float)($price[$i]??0); $vr=(float)($vat[$i]??0);
    $ls=$q*$p; $lv=$ls*($vr/100); $lt=$ls+$lv;
    $subtotal+=$ls; $vat_amount+=$lv; $total+=$lt;
    $lines[]=['sku'=>trim($sku[$i]??''),'name'=>trim($name[$i]??''),'unit'=>trim($unit[$i]??'pcs'),'qty'=>$q,'price'=>$p,'vat'=>$vr,'ls'=>$ls,'lv'=>$lv,'lt'=>$lt];
  }

  $stmt = $conn->prepare("INSERT INTO supplier_credit_notes
    (note_type, credit_note_number, supplier_id, branch_id, invoice_id, credit_date, reason, description_note, subtotal, vat_amount, amount, file_path, created_by, status, workflow_state)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,'active','finalized')");
  $stmt->bind_param('ssiiisssdddsi',
    $note_type,$cn_number,$supplier_id,$branch_id,$invoice_id,$credit_date,$reason,$desc,$subtotal,$vat_amount,$total,$upload_path,$created_by
  );
  if(!$stmt->execute()) throw new Exception($stmt->error);
  $cn_id = $stmt->insert_id; $stmt->close();

  $li = $conn->prepare("INSERT INTO supplier_credit_note_items
    (credit_note_id,item_id,sku,item_name,unit,qty,unit_price,vat_rate,line_subtotal,line_vat,line_total)
    VALUES (?,?,?,?,?,?,?,?,?,?,?)");
  foreach($lines as $ln){
    $item_id = null;
    $li->bind_param('iisssdddddd',$cn_id,$item_id,$ln['sku'],$ln['name'],$ln['unit'],$ln['qty'],$ln['price'],$ln['vat'],$ln['ls'],$ln['lv'],$ln['lt']);
    if(!$li->execute()) throw new Exception($li->error);
  }
  $li->close();

  // Post to AP only if Supplier Credit Note
  if ($note_type === 'Credit Note') {
    $ap = $conn->prepare("INSERT INTO ap_credit_ledger (supplier_id, credit_note_id, amount) VALUES (?,?,?)");
    $ap->bind_param('iid',$supplier_id,$cn_id,$total);
    if(!$ap->execute()) throw new Exception($ap->error);
    $ap->close();
  }

  // Stock OUT for GRN
  if ($note_type === 'Goods Return Note') {
    foreach($lines as $ln){
      $skuEsc=$conn->real_escape_string($ln['sku']); $nmEsc=$conn->real_escape_string($ln['name']); $unitEsc=$conn->real_escape_string($ln['unit']);
      $qty_out = 0 - abs($ln['qty']);
      $conn->query("INSERT INTO stock_movements (movement_type,ref_type,ref_id,item_id,sku,item_name,qty,unit,branch_id)
                    VALUES ('OUT','SUPPLIER_GRN',{$cn_id},NULL,'{$skuEsc}','{$nmEsc}',{$qty_out},'{$unitEsc}',{$branch_id})");
      if($conn->error) throw new Exception($conn->error);
    }
  }

  $conn->commit();
  $_SESSION['success']='Saved successfully.';
  header('Location: view.php?id='.$cn_id); exit;

} catch(Throwable $e){
  $conn->rollback();
  $_SESSION['error']='Failed to save: '.$e->getMessage();
  header('Location: add.php'); exit;
}
