<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Generate CSRF token
$_SESSION['csrf_token'] = bin2hex(random_bytes(32));

// Fetch branches
$branches_query = "SELECT id, branch_name FROM branches";
$branches_result = $conn->query($branches_query);
if (!$branches_result) {
    $_SESSION['error'] = "Failed to fetch branches: " . $conn->error;
    header("Location: add_staff.php");
    exit;
}

// Display session messages
$success = $_SESSION['success'] ?? '';
$error = $_SESSION['error'] ?? '';
unset($_SESSION['success'], $_SESSION['error']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Staff - StaffSync360</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background-color: #f8f9fa; font-size: 14px; }
        .card-header { font-size: 18px; }
        .form-control, .form-select { font-size: 14px; }
        .footer { text-align: center; margin-top: 30px; font-size: 13px; color: #888; }
    </style>
</head>
<body>

<div class="container mt-4">
    <?php if ($success): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo htmlspecialchars($success); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if ($error): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo htmlspecialchars($error); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white text-center"><strong>Add Staff</strong></div>
        <div class="card-body">
            <form action="save.php" method="POST" id="staffForm" enctype="multipart/form-data">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="first_name" class="form-label"><strong>First Name</strong></label>
                        <input type="text" id="first_name" class="form-control" name="first_name" required>
                    </div>
                    <div class="col-md-6">
                        <label for="last_name" class="form-label"><strong>Last Name</strong></label>
                        <input type="text" id="last_name" class="form-control" name="last_name" required>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="national_id" class="form-label"><strong>National ID</strong></label>
                        <input type="text" id="national_id" class="form-control" name="national_id" required maxlength="20">
                    </div>
                    <div class="col-md-6">
                        <label for="email" class="form-label"><strong>Email (Optional)</strong></label>
                        <input type="email" id="email" class="form-control" name="email">
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="phone" class="form-label"><strong>Phone (Optional)</strong></label>
                        <input type="text" id="phone" class="form-control" name="phone">
                    </div>
                    <div class="col-md-6">
                        <label for="branch_id" class="form-label"><strong>Branch</strong></label>
                        <select id="branch_id" class="form-control" name="branch_id" required>
                            <option value="">Select Branch</option>
                            <?php while ($branch = $branches_result->fetch_assoc()): ?>
                                <option value="<?php echo $branch['id']; ?>"><?php echo htmlspecialchars($branch['branch_name']); ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="role" class="form-label"><strong>Role</strong></label>
                        <select id="role" class="form-control" name="role" required>
                            <option value="manager">Manager</option>
                            <option value="supervisor">Supervisor</option>
                            <option value="accountant">Accountant</option>
                            <option value="chief_cashier">Chief Cashier</option>
                            <option value="cashier">Cashier</option>
                            <option value="line_manager">Line Manager</option>
                            <option value="store_clerk">Store Clerk</option>
                            <option value="security">Security</option>
                            <option value="baker">Baker</option>
                            <option value="receiving_clerk">Receiving Clerk</option>
                            <option value="general">General</option>
                            <option value="packer">Packer</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="status" class="form-label"><strong>Status</strong></label>
                        <select id="status" class="form-control" name="status" required>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="monthly_salary" class="form-label">Monthly Salary (Optional)</label>
                        <input type="number" id="monthly_salary" step="0.01" class="form-control" name="monthly_salary">
                    </div>
                    <div class="col-md-6">
                        <label for="hire_date" class="form-label">Hire Date (Optional)</label>
                        <input type="date" id="hire_date" class="form-control" name="hire_date">
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="department" class="form-label">Department (Optional)</label>
                        <input type="text" id="department" class="form-control" name="department">
                    </div>
                    <div class="col-md-6">
                        <label for="bank_account_no" class="form-label">Bank Account No (Optional)</label>
                        <input type="text" id="bank_account_no" class="form-control" name="bank_account_no">
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="photo" class="form-label">Photo (Optional)</label>
                        <input type="file" id="photo" class="form-control" name="photo" accept="image/*">
                    </div>
                </div>
                <div class="text-end mt-3">
                    <button type="submit" class="btn btn-primary">Add Staff</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="footer">
    © <?php echo date("Y"); ?> SmartPay360. All rights reserved.
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.getElementById('staffForm').addEventListener('submit', function(event) {
        const submitButton = document.querySelector('button[type="submit"]');
        const nationalId = document.querySelector('#national_id').value;
        const email = document.querySelector('#email').value;
        const phone = document.querySelector('#phone').value;

        if (nationalId.length > 20) {
            alert('National ID must be 20 characters or less.');
            event.preventDefault();
            return;
        }
        if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
            alert('Invalid email format.');
            event.preventDefault();
            return;
        }
        if (phone && !/^[0-9+\-\(\) ]{0,20}$/.test(phone)) {
            alert('Invalid phone number format.');
            event.preventDefault();
            return;
        }

        if (this.dataset.submitted) {
            event.preventDefault();
        } else {
            this.dataset.submitted = true;
            submitButton.disabled = true;
        }
    });
</script>
</body>
</html>