<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (!isset($_GET['id'])) {
  $_SESSION['error'] = "No supplier specified.";
  header("Location: list.php");
  exit;
}

$id = (int) $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM suppliers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
  $_SESSION['error'] = "Supplier not found.";
  header("Location: list.php");
  exit;
}

$s = $result->fetch_assoc();

if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-edit"></i> Edit Supplier</h4>

  <form action="update_supplier.php" method="POST" class="card shadow-sm p-4 bg-white">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
    <input type="hidden" name="id" value="<?= $s['id'] ?>">

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Supplier Name</label>
        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($s['name']) ?>" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">KRA PIN</label>
        <input type="text" name="kra_pin" class="form-control" value="<?= htmlspecialchars($s['kra_pin']) ?>" required>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Contact Person</label>
        <input type="text" name="contact_person" class="form-control" value="<?= htmlspecialchars($s['contact_person']) ?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Phone</label>
        <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($s['phone']) ?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($s['email']) ?>">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Bank Name</label>
        <input type="text" name="bank_name" class="form-control" value="<?= htmlspecialchars($s['bank_name']) ?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Branch</label>
        <input type="text" name="branch_name" class="form-control" value="<?= htmlspecialchars($s['branch_name']) ?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Account Number</label>
        <input type="text" name="account_no" class="form-control" value="<?= htmlspecialchars($s['account_no']) ?>">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Credit Days</label>
        <input type="number" name="credit_days" class="form-control" value="<?= $s['credit_days'] ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">Credit Limit (KSh)</label>
        <input type="number" step="0.01" name="credit_limit" class="form-control" value="<?= $s['credit_limit'] ?>">
      </div>
    </div>

    <div class="text-end">
      <button type="submit" class="btn btn-success"><i class="fas fa-save me-1"></i> Update Supplier</button>
    </div>
  </form>
</div>
