<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: add.php");
  exit;
}

// CSRF token check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
  $_SESSION['error'] = "CSRF validation failed.";
  header("Location: add.php");
  exit;
}

// Sanitize & capture inputs
$name           = trim($_POST['name']);
$kra_pin        = trim($_POST['kra_pin']);
$contact_person = trim($_POST['contact_person']);
$phone          = trim($_POST['phone']);
$email          = trim($_POST['email']);
$bank_name      = trim($_POST['bank_name']);
$branch_name    = trim($_POST['branch_name']);
$account_no     = trim($_POST['account_no']);
$credit_days    = (int) $_POST['credit_days'];
$credit_limit   = round((float) $_POST['credit_limit'], 2);

// Check if KRA PIN already exists
$check_stmt = $conn->prepare("SELECT kra_pin FROM suppliers WHERE kra_pin = ?");
$check_stmt->bind_param("s", $kra_pin);
$check_stmt->execute();
$check_stmt->store_result();

if ($check_stmt->num_rows > 0) {
  $_SESSION['error'] = "❌ KRA PIN already exists.";
  $check_stmt->close();
  header("Location: add.php");
  exit;
}
$check_stmt->close();

// Prepare and execute insert
$stmt = $conn->prepare("
  INSERT INTO suppliers 
    (name, kra_pin, contact_person, phone, email, bank_name, branch_name, account_no, credit_days, credit_limit, created_at)
  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
");

$stmt->bind_param(
  "ssssssssid",
  $name, $kra_pin, $contact_person, $phone, $email,
  $bank_name, $branch_name, $account_no, $credit_days, $credit_limit
);

if ($stmt->execute()) {
  $_SESSION['success'] = "✅ Supplier added successfully.";
  header("Location: list.php");
  exit;
} else {
  $_SESSION['error'] = "❌ Error saving supplier: " . $stmt->error;
  header("Location: add.php");
  exit;
}

// Note: For better integrity, add a unique constraint to the database:
// ALTER TABLE suppliers ADD CONSTRAINT unique_kra_pin UNIQUE (kra_pin);
?>