<?php
require_once '../../config/db.php';
include '../../includes/layout2.php';

$error = $success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bank_name = trim($_POST['bank_name']);
    $account_number = trim($_POST['account_number']);
    $branch_name = trim($_POST['branch_name']);
    $account_name = trim($_POST['account_name']);

    if ($bank_name && $account_number && $branch_name && $account_name) {
        $stmt = $conn->prepare("INSERT INTO bank_accounts (bank_name, account_number, branch_name, account_name, status, created_at) VALUES (?, ?, ?, ?, 'active', NOW())");
        $stmt->bind_param('ssss', $bank_name, $account_number, $branch_name, $account_name);

        if ($stmt->execute()) {
            $success = "✅ Account added successfully.";
        } else {
            $error = "❌ Failed to save: " . $conn->error;
        }
    } else {
        $error = "❌ All fields are required.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Add Bank Account</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container my-4">
  <div class="card">
    <div class="card-header bg-primary text-white">➕ Add New Bank Account</div>
    <div class="card-body">
      <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
      <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>

      <form method="POST">
        <div class="mb-3">
          <label>Bank Name</label>
          <input type="text" name="bank_name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Account Number</label>
          <input type="text" name="account_number" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Branch Name</label>
          <input type="text" name="branch_name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Account Name</label>
          <input type="text" name="account_name" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success">💾 Save Account</button>
        <a href="record_deposit.php" class="btn btn-secondary">← Back</a>
      </form>
    </div>
  </div>
</div>
</body>
</html>
