<?php
session_start();
require_once '../../config/db.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: cashier_report.php?error=Invalid request.");
    exit;
}

$branch_id = $_POST['branch_id'] ?? '';
$report_date = $_POST['report_date'] ?? '';
$remarks = $_POST['remarks'] ?? '';
$tillCount = 11;

if (!$branch_id || !$report_date) {
    header("Location: cashier_report.php?error=Missing branch or date.");
    exit;
}

$conn->begin_transaction();

try {
    // Insert header
    $stmt = $conn->prepare("INSERT INTO till_report_headers (branch_id, report_date, remarks) VALUES (?, ?, ?)");
    $stmt->bind_param("iss", $branch_id, $report_date, $remarks);
    $stmt->execute();
    $header_id = $stmt->insert_id;
    $stmt->close();

    // Prepare detail insert (23 fields)
    $detailStmt = $conn->prepare("
        INSERT INTO till_report_details (
            report_id, till_no, batch_no, cashier, register,
            opening, drop1, drop2, drop3,
            note_1000, note_500, note_200, note_100, note_50,
            coins, mpesa, visa, credit,
            declared_total, over_short, signature,
            stk, other
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    if (!$detailStmt) {
        throw new Exception("Detail prepare failed: " . $conn->error);
    }

    // Prepare cheque insert
    $chequeStmt = $conn->prepare("
        INSERT INTO till_report_cheques (report_id, till_no, customer_name, cheque_number, amount)
        VALUES (?, ?, ?, ?, ?)
    ");
    if (!$chequeStmt) {
        throw new Exception("Cheque prepare failed: " . $conn->error);
    }

    for ($i = 1; $i <= $tillCount; $i++) {
        $batch = $_POST["batch_$i"] ?? '';
        $cashier = $_POST["cashier_$i"] ?? '';
        $register = $_POST["register_$i"] ?? '';
        $opening = floatval($_POST["opening_$i"] ?? 0);
        $drop1 = floatval($_POST["drop1_$i"] ?? 0);
        $drop2 = floatval($_POST["drop2_$i"] ?? 0);
        $drop3 = floatval($_POST["drop3_$i"] ?? 0);
        $note_1000 = floatval($_POST["note_1000_$i"] ?? 0);
        $note_500 = floatval($_POST["note_500_$i"] ?? 0);
        $note_200 = floatval($_POST["note_200_$i"] ?? 0);
        $note_100 = floatval($_POST["note_100_$i"] ?? 0);
        $note_50 = floatval($_POST["note_50_$i"] ?? 0);
        $coins = floatval($_POST["coins_$i"] ?? 0);
        $mpesa = floatval($_POST["mpesa_$i"] ?? 0);
        $visa = floatval($_POST["visa_$i"] ?? 0);
        $credit = floatval($_POST["credit_$i"] ?? 0);
        $declared_total = floatval($_POST["declared_total_$i"] ?? 0);
        $over_short = $_POST["over_short_$i"] ?? '';
        $signature = $_POST["signature_$i"] ?? '';
        $stk = floatval($_POST["stk_$i"] ?? 0);
        $other = floatval($_POST["other_$i"] ?? 0);

        // Skip empty tills
        $hasData = $drop1 + $drop2 + $drop3 + $note_1000 + $note_500 + $note_200 + $note_100 + $note_50 + $coins + $mpesa + $visa + $credit + $stk + $other;
        if ($hasData == 0) continue;

        $detailStmt->bind_param(
            "iisssddddddddddddddssdd",
            $header_id, $i, $batch, $cashier, $register,
            $opening, $drop1, $drop2, $drop3,
            $note_1000, $note_500, $note_200, $note_100, $note_50,
            $coins, $mpesa, $visa, $credit,
            $declared_total, $over_short, $signature,
            $stk, $other
        );
        $detailStmt->execute();

        // Handle cheque rows
        $cheque_customers = $_POST["cheque_customer_$i"] ?? [];
        $cheque_numbers = $_POST["cheque_number_$i"] ?? [];
        $cheque_amounts = $_POST["cheque_amount_$i"] ?? [];

        for ($j = 0; $j < count($cheque_customers); $j++) {
            $cust = trim($cheque_customers[$j]);
            $cheque_no = trim($cheque_numbers[$j]);
            $amount = floatval($cheque_amounts[$j] ?? 0);
            if ($cust && $cheque_no && $amount > 0) {
                $chequeStmt->bind_param("iissd", $header_id, $i, $cust, $cheque_no, $amount);
                $chequeStmt->execute();
            }
        }
    }

    $detailStmt->close();
    $chequeStmt->close();
    $conn->commit();

    header("Location: till_report.php?success=Report saved successfully.");
    exit;

} catch (Exception $e) {
    $conn->rollback();
    header("Location: till_report.php?error=Save failed: " . urlencode($e->getMessage()));
    exit;
}
