<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: manage_cashiers.php?error=Invalid ID");
    exit;
}

$id = (int) $_GET['id'];

// Optional: Prevent deleting if the cashier is linked elsewhere (in transactions, etc)

$stmt = $conn->prepare("DELETE FROM cashiers WHERE id = ?");
$stmt->bind_param("i", $id);
if ($stmt->execute()) {
    header("Location: manage_cashiers.php?success=Cashier deleted");
} else {
    header("Location: manage_cashiers.php?error=Unable to delete cashier");
}
exit;
