<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC")->fetch_all(MYSQLI_ASSOC);

$filter_branch = $_GET['branch_id'] ?? '';
$filter_date = $_GET['report_date'] ?? '';

$query = "SELECT h.*, b.branch_name,
            (SELECT COUNT(*) FROM till_report_details d WHERE d.report_id = h.id) as till_count
          FROM till_report_headers h
          JOIN branches b ON b.id = h.branch_id
          WHERE 1=1";

if (!empty($filter_branch)) {
    $query .= " AND h.branch_id = " . intval($filter_branch);
}
if (!empty($filter_date)) {
    $query .= " AND h.report_date = '" . $conn->real_escape_string($filter_date) . "'";
}
$query .= " ORDER BY h.report_date DESC, h.id DESC";

$results = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>List of Till Reports</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f9f9f9; font-size: 14px; }
    .table thead th { background: #0d6efd; color: white; }
  </style>
</head>
<body>
<div class="container mt-4">
  <h4 class="mb-3 text-primary"><i class="fas fa-list"></i> Cashier Till Reports</h4>

  <form class="row g-2 mb-3" method="get">
    <div class="col-md-3">
      <label>Filter by Branch</label>
      <select name="branch_id" class="form-select">
        <option value="">All Branches</option>
        <?php foreach ($branches as $b): ?>
          <option value="<?= $b['id'] ?>" <?= ($b['id'] == $filter_branch) ? 'selected' : '' ?>>
            <?= htmlspecialchars($b['branch_name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label>Filter by Date</label>
      <input type="date" name="report_date" value="<?= htmlspecialchars($filter_date) ?>" class="form-control">
    </div>
    <div class="col-md-3 d-flex align-items-end">
      <button class="btn btn-primary btn-sm" type="submit">Filter</button>
      <a href="list_reports.php" class="btn btn-secondary btn-sm ms-2">Reset</a>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-striped align-middle text-center">
      <thead>
        <tr>
          <th>#</th>
          <th>Report Date</th>
          <th>Branch</th>
          <th>Remarks</th>
          <th>Tills Recorded</th>
          <th>Created At</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($results && $results->num_rows > 0): ?>
          <?php $count = 1; while ($row = $results->fetch_assoc()): ?>
            <tr>
              <td><?= $count++ ?></td>
              <td><?= htmlspecialchars($row['report_date']) ?></td>
              <td><?= htmlspecialchars($row['branch_name']) ?></td>
              <td><?= htmlspecialchars($row['remarks']) ?></td>
              <td><?= $row['till_count'] ?></td>
              <td><?= date('d-M-Y H:i', strtotime($row['created_at'])) ?></td>
              <td>
                <a href="view_report.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-info">View</a>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="7" class="text-muted">No reports found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script src="https://kit.fontawesome.com/a2e0e6ad65.js" crossorigin="anonymous"></script>
</body>
</html>
