<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: record_deposit.php?error=Invalid+request");
    exit;
}

// Collect form data
$report_id = $_POST['report_id'] ?? null;
$deposit_amount = $_POST['deposit_amount'] ?? 0;
$deposit_date = $_POST['deposit_date'] ?? date('Y-m-d');
$reference_number = $_POST['reference_number'] ?? '';
$deposited_by = $_POST['deposited_by'] ?? '';
$account_id = $_POST['account_id'] ?? null;
$remarks = $_POST['remarks'] ?? '';
$deposit_type = 'Cash';
$branch_name = $_SESSION['branch_name'] ?? 'Main'; // Must be set during login

// Validate required fields
if (!$report_id || !$deposit_amount || !$deposit_date || !$reference_number || !$deposited_by || !$account_id || !$branch_name) {
    header("Location: record_deposit.php?error=Missing+required+fields");
    exit;
}

// Fetch bank_name from account_id
$bank_name = '';
$bank_stmt = $conn->prepare("SELECT bank_name FROM bank_accounts WHERE id = ?");
$bank_stmt->bind_param("i", $account_id);
$bank_stmt->execute();
$bank_stmt->bind_result($bank_name);
$bank_stmt->fetch();
$bank_stmt->close();

if (!$bank_name) {
    header("Location: record_deposit.php?error=Invalid+bank+account");
    exit;
}

// Handle file upload (optional slip)
$upload_path = '';
if (isset($_FILES['deposit_slip']) && $_FILES['deposit_slip']['error'] == UPLOAD_ERR_OK) {
    $ext = pathinfo($_FILES['deposit_slip']['name'], PATHINFO_EXTENSION);
    $upload_path = 'uploads/slips/' . uniqid('cash_') . '.' . $ext;

    // Ensure upload folder exists
    $upload_dir = dirname(__DIR__, 2) . '/uploads/slips/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0775, true);
    }

    move_uploaded_file($_FILES['deposit_slip']['tmp_name'], '../../' . $upload_path);
}

// Insert into bank_deposits
$stmt = $conn->prepare("INSERT INTO bank_deposits 
    (report_id, account_id, bank_name, deposit_type, deposit_amount, deposit_date, reference_number, deposited_by, branch_name, remarks, slip_path, created_at)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

$stmt->bind_param("iissdssssss", 
    $report_id,
    $account_id,
    $bank_name,
    $deposit_type,
    $deposit_amount,
    $deposit_date,
    $reference_number,
    $deposited_by,
    $branch_name,
    $remarks,
    $upload_path
);

// Execute and handle result
if ($stmt->execute()) {
    header("Location: record_deposit.php?success=Cash+deposit+saved+successfully");
    exit;
} else {
    error_log("SQL Error: " . $stmt->error);
    header("Location: record_deposit.php?error=Failed+to+save+cash+deposit");
    exit;
}
