<?php
session_start();
require_once '../config/db.php';
include '../auth/auth_check.php';

if ($_SESSION['role'] !== 'Admin') {
    header("Location: ../unauthorized.php");
    exit;
}

// Fetch branches for filter
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);

// Filter setup
$filter_branch = $_GET['branch_id'] ?? '';
$filter_sql = !empty($filter_branch) ? "AND r.branch_id = " . intval($filter_branch) : "";

// Fetch users with branch info
$query = "
    SELECT 
        u.id, u.full_name, u.username, u.status, u.last_login,
        r.role_name, b.branch_name
    FROM users u
    JOIN user_roles r ON u.role_id = r.id
    LEFT JOIN branches b ON r.branch_id = b.id
    WHERE 1=1 $filter_sql
    ORDER BY u.full_name ASC
";
$users = $conn->query($query);
include '../includes/layout2.php';
?>

<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold">👥 Manage Users</h4>
    <a href="register.php" class="btn btn-primary">➕ Add User</a>
  </div>

  <form class="row mb-3" method="get">
    <div class="col-md-4">
      <select name="branch_id" class="form-select" onchange="this.form.submit()">
        <option value="">🔍 Filter by Branch</option>
        <?php foreach ($branches as $branch): ?>
          <option value="<?= $branch['id'] ?>" <?= $filter_branch == $branch['id'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($branch['branch_name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-striped align-middle">
      <thead class="table-dark">
        <tr class="text-center">
          <th>#</th>
          <th>Full Name</th>
          <th>Username</th>
          <th>Role</th>
          <th>Branch</th>
          <th>Status</th>
          <th>Last Login</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $i=1; while ($row = $users->fetch_assoc()): ?>
          <tr>
            <td class="text-center"><?= $i++ ?></td>
            <td><?= htmlspecialchars($row['full_name']) ?></td>
            <td><?= htmlspecialchars($row['username']) ?></td>
            <td><?= htmlspecialchars($row['role_name']) ?></td>
            <td><?= htmlspecialchars($row['branch_name'] ?? 'Global') ?></td>
            <td class="text-center">
              <span class="badge bg-<?= $row['status'] === 'active' ? 'success' : 'secondary' ?>">
                <?= ucfirst($row['status']) ?>
              </span>
            </td>
            <td class="text-center"><?= $row['last_login'] ?? '-' ?></td>
            <td class="text-center">
              <a href="edit_user.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">✏️ Edit</a>
              <a href="delete_user.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this user?')">🗑️ Delete</a>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>
