<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Fetch branches
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);
$tillCount = 11;
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Cashier Till Report</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; font-size: 13px; }
    .container, .container-fluid { max-width: 98%; padding: 25px; }
    .nav-tabs { overflow-x: auto; white-space: nowrap; }
    .nav-tabs .nav-link.active { background-color: #0d6efd; color: #fff; }
    .card-header { background: #0d6efd; color: #fff; font-size: 13px; padding: 8px 12px; }
    .form-control, .form-select { font-size: 13px; padding: 6px 8px; }
    .summary-bar { background: #0056b3; color: #fff; padding: 12px 20px; margin-bottom: 15px; font-weight: bold; font-size: 15px; }
    .summary-bar span { color: #ffdd57; }
    input[readonly] { background: #e3f2fd; font-weight: bold; }
    @media print {
      .no-print, .nav-tabs, .tab-content > .tab-pane:not(.active), .table-responsive {
        display: none !important;
      }
    }
  </style>
</head>
<body>
    
<div class="container my-3">
  <h5 class="text-center mb-3">Cashier Till Report</h5>

  <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_GET['success']) ?></div>
  <?php endif; ?>
  <?php if (isset($_GET['error'])): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($_GET['error']) ?></div>
  <?php endif; ?>
  
<div class="d-flex justify-content-between align-items-center mb-3">
  <h5 class="mb-0">Cashier Till Report</h5>
  <a href="manage_cashiers.php" class="btn btn-sm btn-dark">
    👥 Manage Cashiers
  </a>
</div>

  <div class="summary-bar">
    <div class="row">
      <div class="col"><strong>Total Drop:</strong> <span id="grandDrop">0.00</span></div>
      <div class="col"><strong>Total Cash:</strong> <span id="grandCash">0.00</span></div>
      <div class="col"><strong>MPESA:</strong> <span id="grandMpesa">0.00</span></div>
      <div class="col"><strong>VISA:</strong> <span id="grandVisa">0.00</span></div>
      <div class="col"><strong>Grand Total:</strong> <span id="grandAll">0.00</span></div>
    </div>
  </div>

  <form method="POST" action="save_till_report.php" id="tillReportForm">
    <div class="row mb-3">
      <div class="col-md-4">
        <label>Branch</label>
        <select name="branch_id" class="form-select" required>
          <option value="">Select Branch</option>
          <?php foreach ($branches as $b): ?>
            <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['branch_name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label>Date</label>
        <input type="date" name="report_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
      </div>
      <div class="col-md-4">
        <label>Remarks</label>
        <input type="text" name="remarks" class="form-control">
      </div>
    </div>

    <ul class="nav nav-tabs no-print" id="tillTab" role="tablist">
      <?php for ($i = 1; $i <= $tillCount; $i++): ?>
        <li class="nav-item" role="presentation">
          <button class="nav-link <?= $i === 1 ? 'active' : '' ?>" id="till<?= $i ?>-tab" data-bs-toggle="tab" data-bs-target="#till<?= $i ?>" type="button" role="tab">Till <?= $i ?></button>
        </li>
      <?php endfor; ?>
    </ul>

    <div class="tab-content border border-top-0 p-3 bg-white" id="tillTabContent">
      <?php for ($i = 1; $i <= $tillCount; $i++): ?>
        <div class="tab-pane fade <?= $i === 1 ? 'show active' : '' ?>" id="till<?= $i ?>" role="tabpanel">
          <div class="card-header">TILL <?= $i ?> REPORT</div>
          <div class="card-body small p-2">
            <div class="row g-2">
              <?php
              $fields = [
  "Batch No." => "batch", "Cashier" => "cashier", "Register" => "register", "Opening" => "opening",
  "Drop 1" => "drop1", "Drop 2" => "drop2", "Drop 3" => "drop3",
  "1000s" => "note_1000", "500s" => "note_500", "200s" => "note_200", "100s" => "note_100", "50s" => "note_50",
  "Coins" => "coins", "MPESA" => "mpesa", "VISA" => "visa", "STK Push" => "stk", "Credit Account" => "credit",
  "Other Tender" => "other", "Over/Short" => "over_short", "Signature" => "signature"
];

              foreach ($fields as $label => $name):
                $inputType = ($name === 'cashier') ? 'select' : 'input';
                $isMoney = in_array($name, ['opening','drop1','drop2','drop3','note_1000','note_500','note_200','note_100','note_50','coins','mpesa','visa','stk','other']);
                ?>
                <div class="col-md-2">
                  <label><?= $label ?></label>
                  <?php if ($inputType === 'input'): ?>
                    <input type="<?= $isMoney ? 'number' : 'text' ?>" step="<?= $isMoney ? '0.01' : '' ?>" name="<?= $name ?>_<?= $i ?>" class="form-control drop<?= $i ?>">
                  <?php else: ?>
                    <?php
$cashiers = $conn->query("SELECT id, name FROM cashiers WHERE status = 'Active' ORDER BY name")->fetch_all(MYSQLI_ASSOC);
?>

<?php
$cashiers = $conn->query("SELECT id, name FROM cashiers WHERE status = 'Active' ORDER BY name")->fetch_all(MYSQLI_ASSOC);
?>

<select name="cashier_<?= $i ?>" class="form-select">
  <option value="">-- Select Cashier --</option>
  <?php foreach ($cashiers as $cashier): ?>
    <option value="<?= htmlspecialchars($cashier['name']) ?>"><?= htmlspecialchars($cashier['name']) ?></option>
  <?php endforeach; ?>
</select>


                  <?php endif; ?>
                </div>
              <?php endforeach; ?>
            </div>

            <!-- Cheques -->
            <div class="mt-3">
              <label>Customer Cheques</label>
              <table class="table table-bordered table-sm" id="chequeTable<?= $i ?>">
                <thead class="table-light">
                  <tr><th>Customer Name</th><th>Cheque No</th><th>Amount</th><th></th></tr>
                </thead>
                <tbody></tbody>
              </table>
              <button type="button" class="btn btn-sm btn-primary" onclick="addChequeRow(<?= $i ?>)">➕ Add Cheque</button>
            </div>

            <div class="row mt-2">
              <div class="col"><label>Total Drop</label><input type="text" class="form-control total-drop<?= $i ?>" readonly></div>
              <div class="col"><label>Total Notes</label><input type="text" class="form-control tt-notes<?= $i ?>" readonly></div>
              <div class="col"><label>Total Cash</label><input type="text" class="form-control total-cash<?= $i ?>" readonly></div>
              <div class="col"><label>Total All</label><input type="text" class="form-control total-all<?= $i ?>" readonly></div>
            </div>
            <div class="row mt-2">
  <div class="col-md-3">
    <label>Declared Total Sales</label>
    <input type="number" step="0.01" name="declared_total_<?= $i ?>" class="form-control declared-total" data-till="<?= $i ?>">
  </div>
  <div class="col-md-3">
    <label>Auto Over/Short</label>
    <input type="text" name="auto_over_short_<?= $i ?>" class="form-control auto-over-short" readonly>
  </div>
</div>

          </div>
        </div>
      <?php endfor; ?>
    </div>

    <div class="text-end mt-3">
      <button type="submit" class="btn btn-success btn-sm">💾 Save Report</button>
      <button type="button" class="btn btn-secondary btn-sm" onclick="window.print()">🖨️ Print</button>
    </div>
  </form>

  <div class="container mt-4">
    <h6>🔍 Till Summary Table (Live)</h6>
    <div class="table-responsive" style="max-height: 300px;">
      <table class="table table-sm table-bordered table-striped text-center align-middle" id="summaryTable">
        <thead class="table-light sticky-top">
          <tr>
            <th>Till</th><th>Batch</th><th>Cashier</th><th>Register</th>
            <th>Coins</th><th>Total Notes</th><th>Total Cash</th>
<th>MPESA</th><th>VISA</th><th>Credit</th><th>Grand Total</th>
          </tr>
        </thead>
        <tbody id="summaryBody"></tbody>
        <tfoot class="table-primary sticky-bottom">
  <tr>
    <th colspan="4" class="text-end">TOTALS:</th>
    <th id="sumCoins">0.00</th>
    <th id="sumNotes">0.00</th>
    <th id="sumCash">0.00</th>
    <th id="sumMpesa">0.00</th>
    <th id="sumVisa">0.00</th>
    <th id="sumCredit">0.00</th> <!-- You missed this -->
    <th id="sumTotal">0.00</th>
  </tr>
</tfoot>
      </table>
    </div>
  </div>
</div>

<script>
function formatCurrency(val) {
  return parseFloat(val || 0).toLocaleString('en-KE', { minimumFractionDigits: 2 });
}
function addChequeRow(till) {
  const tbody = document.querySelector(`#chequeTable${till} tbody`);
  const row = document.createElement('tr');
  row.innerHTML = `
    <td><input name="cheque_customer_${till}[]" class="form-control form-control-sm" required></td>
    <td><input name="cheque_number_${till}[]" class="form-control form-control-sm" required></td>
    <td><input name="cheque_amount_${till}[]" class="form-control form-control-sm chequeAmount${till}" step="0.01" type="number" oninput="calculateTotals()"></td>
    <td><button type="button" class="btn btn-danger btn-sm" onclick="this.closest('tr').remove(); calculateTotals();">✖</button></td>
  `;
  tbody.appendChild(row);
}
function calculateTotals() {
  let grandDrop = 0, grandCash = 0, grandMpesa = 0, grandVisa = 0, grandAll = 0;
  let sumCoins = 0, sumNotes = 0, sumTotalCash = 0, sumMpesa = 0, sumVisa = 0,sumCredit = 0, sumTotal = 0;
  document.getElementById('summaryBody').innerHTML = '';

  for (let i = 1; i <= <?= $tillCount ?>; i++) {
    let dropTotal = ['drop1_', 'drop2_', 'drop3_'].reduce((sum, d) => sum + (parseFloat(document.querySelector(`[name='${d}${i}']`)?.value) || 0), 0);
    let d1000 = parseFloat(document.querySelector(`[name='note_1000_${i}']`)?.value) || 0;
    let d500 = parseFloat(document.querySelector(`[name='note_500_${i}']`)?.value) || 0;
    let d200 = parseFloat(document.querySelector(`[name='note_200_${i}']`)?.value) || 0;
    let d100 = parseFloat(document.querySelector(`[name='note_100_${i}']`)?.value) || 0;
    let d50 = parseFloat(document.querySelector(`[name='note_50_${i}']`)?.value) || 0;
    let coins = parseFloat(document.querySelector(`[name='coins_${i}']`)?.value) || 0;
    let mpesa = parseFloat(document.querySelector(`[name='mpesa_${i}']`)?.value) || 0;
    let stk = parseFloat(document.querySelector(`[name='stk_${i}']`)?.value) || 0;
    let visa = parseFloat(document.querySelector(`[name='visa_${i}']`)?.value) || 0;
    let other = parseFloat(document.querySelector(`[name='other_${i}']`)?.value) || 0;
    let credit = parseFloat(document.querySelector(`[name='credit_${i}']`)?.value) || 0;
    let cheques = [...document.querySelectorAll(`.chequeAmount${i}`)].reduce((sum, el) => sum + (parseFloat(el.value) || 0), 0);

    let ttNotes = d1000 + d500 + d200 + d100 + d50;
    let totalCash = dropTotal + ttNotes + coins;
    let totalAll = totalCash + mpesa + stk + visa + other + credit + cheques;

    

    document.querySelector(`.total-drop${i}`).value = formatCurrency(dropTotal);
    document.querySelector(`.tt-notes${i}`).value = formatCurrency(ttNotes);
    document.querySelector(`.total-cash${i}`).value = formatCurrency(totalCash);
    document.querySelector(`.total-all${i}`).value = formatCurrency(totalAll);
    let declaredEl = document.querySelector(`[name='declared_total_${i}']`);
let overShortEl = document.querySelector(`[name='auto_over_short_${i}']`);
if (declaredEl && overShortEl) {
  let declared = parseFloat(declaredEl.value) || 0;
  let diff = declared - totalAll;
overShortEl.value = (diff >= 0 ? '+' : '') + formatCurrency(diff);
}


    if (totalAll > 0) {
      let batch = document.querySelector(`[name='batch_${i}']`)?.value || '-';
      let cashier = document.querySelector(`[name='cashier_${i}']`)?.value || '-';
      let register = document.querySelector(`[name='register_${i}']`)?.value || '-';
     document.getElementById('summaryBody').innerHTML += `
  <tr><td>Till ${i}</td><td>${batch}</td><td>${cashier}</td><td>${register}</td>
  <td>${formatCurrency(coins)}</td><td>${formatCurrency(ttNotes)}</td>
  <td>${formatCurrency(totalCash)}</td><td>${formatCurrency(mpesa + stk)}</td>
  <td>${formatCurrency(visa)}</td><td>${formatCurrency(credit)}</td><td>${formatCurrency(totalAll)}</td></tr>`;

    }

    grandDrop += dropTotal;
    grandCash += totalCash;
    grandMpesa += mpesa + stk;
    grandVisa += visa;
    grandAll += totalAll;
    sumCoins += coins;
    sumNotes += ttNotes;
    sumTotalCash += totalCash;
    sumMpesa += mpesa + stk;
    sumVisa += visa;
    sumCredit += credit;
    sumTotal += totalAll;
  }

  document.getElementById('grandDrop').innerText = formatCurrency(grandDrop);
  document.getElementById('grandCash').innerText = formatCurrency(grandCash);
  document.getElementById('grandMpesa').innerText = formatCurrency(grandMpesa);
  document.getElementById('grandVisa').innerText = formatCurrency(grandVisa);
  document.getElementById('grandAll').innerText = formatCurrency(grandAll);
  document.getElementById('sumCoins').innerText = formatCurrency(sumCoins);
  document.getElementById('sumNotes').innerText = formatCurrency(sumNotes);
  document.getElementById('sumCash').innerText = formatCurrency(sumTotalCash);
  document.getElementById('sumMpesa').innerText = formatCurrency(sumMpesa);
  document.getElementById('sumVisa').innerText = formatCurrency(sumVisa);
  document.getElementById('sumCredit').innerText = formatCurrency(sumCredit);
  document.getElementById('sumTotal').innerText = formatCurrency(sumTotal);
}

document.querySelectorAll('input, select').forEach(el => el.addEventListener('input', calculateTotals));
document.querySelectorAll('.declared-total').forEach(el => el.addEventListener('input', calculateTotals));
calculateTotals();
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
