<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Filters
$from = $_GET['from'] ?? date('Y-m-d', strtotime('-7 days'));
$to = $_GET['to'] ?? date('Y-m-d');
$branch_filter = $_GET['branch'] ?? '';

// Branches
$allBranches = [];
$branchRes = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name");
while ($b = $branchRes->fetch_assoc()) {
    $allBranches[$b['id']] = $b['branch_name'];
}

// Query
$where = "WHERE h.report_date BETWEEN ? AND ?";
$params = [$from, $to];
$types = 'ss';

if ($branch_filter) {
    $where .= " AND b.branch_name = ?";
    $params[] = $branch_filter;
    $types .= 's';
}

$sql = "
    SELECT h.id AS report_id, h.report_date, h.remarks, b.id AS branch_id, b.branch_name
    FROM till_report_headers h
    JOIN branches b ON b.id = h.branch_id
    $where
    ORDER BY h.report_date DESC, b.branch_name ASC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();

$reportsByDate = [];
$totals = [];

while ($row = $result->fetch_assoc()) {
    $report_id = $row['report_id'];

    // Aggregates
    $cashRow = $conn->query("SELECT 
        SUM(drop1 + drop2 + drop3 + note_1000 + note_500 + note_200 + note_100 + note_50 + coins) AS total_cash,
        SUM(mpesa) AS mpesa_total,
        SUM(visa) AS visa_total
        FROM till_report_details WHERE report_id = $report_id")->fetch_assoc();

    $total_cash = floatval($cashRow['total_cash'] ?? 0);
    $mpesa_total = floatval($cashRow['mpesa_total'] ?? 0);
    $visa_total = floatval($cashRow['visa_total'] ?? 0);

    $banked = floatval($conn->query("SELECT SUM(deposit_amount) AS total FROM bank_deposits WHERE report_id = $report_id")->fetch_assoc()['total'] ?? 0);
    $cheque_total = floatval($conn->query("SELECT SUM(amount) AS total FROM till_report_cheques WHERE report_id = $report_id")->fetch_assoc()['total'] ?? 0);

    $row['cash'] = $total_cash;
    $row['mpesa'] = $mpesa_total;
    $row['visa'] = $visa_total;
    $row['cheques'] = $cheque_total;
    $row['banked'] = $banked;
    $row['remaining'] = $total_cash - $banked;

    $reportsByDate[$row['report_date']][$row['branch_id']] = $row;

    if (!isset($totals[$row['report_date']])) {
        $totals[$row['report_date']] = ['reported' => 0, 'missed' => 0, 'cash' => 0, 'mpesa' => 0, 'visa' => 0, 'cheques' => 0];
    }

    $totals[$row['report_date']]['reported']++;
    $totals[$row['report_date']]['cash'] += $total_cash;
    $totals[$row['report_date']]['mpesa'] += $mpesa_total;
    $totals[$row['report_date']]['visa'] += $visa_total;
    $totals[$row['report_date']]['cheques'] += $cheque_total;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Deposit Summary</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    .modal-header.bg-primary, .modal-header.bg-success, .modal-header.bg-info {
      color: white;
    }
    .list-group-item {
      margin-bottom: 5px;
      border-left: 5px solid #0d6efd;
    }
  </style>
</head>
<body>
<div class="container my-4">
  <h4 class="mb-4">📊 Daily Deposit Summary & Breakdown</h4>

  <form class="row g-2 mb-3" method="GET">
    <div class="col-md-3">
      <label>From</label>
      <input type="date" name="from" class="form-control" value="<?= htmlspecialchars($from) ?>">
    </div>
    <div class="col-md-3">
      <label>To</label>
      <input type="date" name="to" class="form-control" value="<?= htmlspecialchars($to) ?>">
    </div>
    <div class="col-md-3">
      <label>Branch</label>
      <select name="branch" class="form-select">
        <option value="">All Branches</option>
        <?php foreach ($allBranches as $id => $name): ?>
          <option value="<?= $name ?>" <?= $branch_filter === $name ? 'selected' : '' ?>><?= $name ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex align-items-end">
      <button class="btn btn-primary w-100">🔍 Filter</button>
    </div>
  </form>

  <?php if (empty($reportsByDate)): ?>
    <div class="alert alert-info">No data found for selected filters.</div>
  <?php else: ?>
    <table class="table table-bordered table-sm">
      <thead class="table-light">
        <tr>
          <th>Branch</th>
          <th>Report</th>
          <th>Date</th>
          <th>Cash</th>
          <th>Banked</th>
          <th>Remaining</th>
          <th>MPESA</th>
          <th>VISA</th>
          <th>Cheques</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($reportsByDate as $date => $branches): ?>
          <?php $summary = $totals[$date]; $missed = count($allBranches) - $summary['reported']; ?>
          <tr class="table-info fw-bold">
            <td colspan="10">📅 <?= $date ?> | ✅ <?= $summary['reported'] ?> Reported | ❌ <?= $missed ?> Missed |
              💵 Cash: Ksh <?= number_format($summary['cash'], 2) ?> |
              📲 MPESA: <?= number_format($summary['mpesa'], 2) ?> |
              💳 VISA: <?= number_format($summary['visa'], 2) ?> |
              🧾 Cheques: <?= number_format($summary['cheques'], 2) ?>
            </td>
          </tr>
          <?php foreach ($allBranches as $branchId => $branchName): ?>
            <?php if (isset($branches[$branchId])): $r = $branches[$branchId]; ?>
              <tr>
                <td><?= $branchName ?></td>
                <td>#<?= $r['report_id'] ?></td>
                <td><?= $r['report_date'] ?></td>
                <td>Ksh <?= number_format($r['cash'], 2) ?></td>
                <td>Ksh <?= number_format($r['banked'], 2) ?></td>
                <td class="text-danger">Ksh <?= number_format($r['remaining'], 2) ?></td>
                <td><button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#mpesaModal<?= $r['report_id'] ?>">View</button></td>
                <td><button class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#visaModal<?= $r['report_id'] ?>">View</button></td>
                <td><button class="btn btn-sm btn-outline-success" data-bs-toggle="modal" data-bs-target="#chequeModal<?= $r['report_id'] ?>">View</button></td>
                <td><a href="record_deposit.php?report_id=<?= $r['report_id'] ?>" class="btn btn-sm btn-success">➕ Deposit</a></td>
              </tr>

              <!-- MPESA Modal -->
              <div class="modal fade" id="mpesaModal<?= $r['report_id'] ?>" tabindex="-1">
                <div class="modal-dialog"><div class="modal-content">
                  <div class="modal-header bg-primary"><h5 class="modal-title">📲 MPESA - Report #<?= $r['report_id'] ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                  <div class="modal-body">
                    <ul class="list-group">
                      <?php $mpesa = $conn->query("SELECT till_no, mpesa FROM till_report_details WHERE report_id = " . $r['report_id']);
                      while ($m = $mpesa->fetch_assoc()): ?>
                        <li class="list-group-item">Till <?= $m['till_no'] ?> - Ksh <?= number_format($m['mpesa'], 2) ?></li>
                      <?php endwhile; ?>
                    </ul>
                  </div>
                </div></div>
              </div>

              <!-- VISA Modal -->
              <div class="modal fade" id="visaModal<?= $r['report_id'] ?>" tabindex="-1">
                <div class="modal-dialog"><div class="modal-content">
                  <div class="modal-header bg-info"><h5 class="modal-title">💳 VISA - Report #<?= $r['report_id'] ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                  <div class="modal-body">
                    <ul class="list-group">
                      <?php $visa = $conn->query("SELECT till_no, visa FROM till_report_details WHERE report_id = " . $r['report_id']);
                      while ($v = $visa->fetch_assoc()): ?>
                        <li class="list-group-item">Till <?= $v['till_no'] ?> - Ksh <?= number_format($v['visa'], 2) ?></li>
                      <?php endwhile; ?>
                    </ul>
                  </div>
                </div></div>
              </div>

              <!-- Cheque Modal -->
              <div class="modal fade" id="chequeModal<?= $r['report_id'] ?>" tabindex="-1">
                <div class="modal-dialog"><div class="modal-content">
                  <div class="modal-header bg-success"><h5 class="modal-title">🧾 Cheques - Report #<?= $r['report_id'] ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                  <div class="modal-body">
                    <ul class="list-group">
                      <?php
                      $cheques = $conn->query("SELECT till_no, customer_name, cheque_number, amount FROM till_report_cheques WHERE report_id = " . $r['report_id']);
                      if ($cheques->num_rows == 0): ?>
                        <li class="list-group-item">No cheques recorded.</li>
                      <?php else:
                        while ($c = $cheques->fetch_assoc()): ?>
                          <li class="list-group-item">
                            <strong>Till <?= $c['till_no'] ?></strong><br>
                            <?= htmlspecialchars($c['customer_name']) ?> <br>
                            Cheque: <strong><?= htmlspecialchars($c['cheque_number']) ?></strong><br>
                            <span class="text-success fw-bold">Ksh <?= number_format($c['amount'], 2) ?></span>
                          </li>
                      <?php endwhile; endif; ?>
                    </ul>
                  </div>
                </div></div>
              </div>

            <?php else: ?>
              <tr class="table-danger">
                <td class="fw-bold text-danger"><?= $branchName ?></td>
                <td colspan="9">❌ No report submitted.</td>
              </tr>
            <?php endif; ?>
          <?php endforeach; ?>
        <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>
</div>
</body>
</html>
